// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about a restore job.
 */
public class RestoreJobsListMember private constructor(builder: Builder) {
    /**
     * The account ID that owns the restore job.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The size, in bytes, of the restored resource.
     */
    public val backupSizeInBytes: kotlin.Long? = builder.backupSizeInBytes
    /**
     * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * Contains identifying information about the creation of a restore job.
     */
    public val createdBy: aws.sdk.kotlin.services.backup.model.RestoreJobCreator? = builder.createdBy
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val createdResourceArn: kotlin.String? = builder.createdResourceArn
    /**
     * The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * This notes the status of the data generated by the restore test. The status may be `Deleting`, `Failed`, or `Successful`.
     */
    public val deletionStatus: aws.sdk.kotlin.services.backup.model.RestoreDeletionStatus? = builder.deletionStatus
    /**
     * This describes the restore job deletion status.
     */
    public val deletionStatusMessage: kotlin.String? = builder.deletionStatusMessage
    /**
     * The amount of time in minutes that a job restoring a recovery point is expected to take.
     */
    public val expectedCompletionTimeMinutes: kotlin.Long? = builder.expectedCompletionTimeMinutes
    /**
     * The IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * Contains an estimated percentage complete of a job at the time the job status was queried.
     */
    public val percentDone: kotlin.String? = builder.percentDone
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * The date on which a recovery point was created.
     */
    public val recoveryPointCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.recoveryPointCreationDate
    /**
     * The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * Uniquely identifies the job that restores a recovery point.
     */
    public val restoreJobId: kotlin.String? = builder.restoreJobId
    /**
     * A status code specifying the state of the job initiated by Backup to restore a recovery point.
     */
    public val status: aws.sdk.kotlin.services.backup.model.RestoreJobStatus? = builder.status
    /**
     * A detailed message explaining the status of the job to restore a recovery point.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The status of validation run on the indicated restore job.
     */
    public val validationStatus: aws.sdk.kotlin.services.backup.model.RestoreValidationStatus? = builder.validationStatus
    /**
     * This describes the status of validation run on the indicated restore job.
     */
    public val validationStatusMessage: kotlin.String? = builder.validationStatusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreJobsListMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreJobsListMember(")
        append("accountId=$accountId,")
        append("backupSizeInBytes=$backupSizeInBytes,")
        append("completionDate=$completionDate,")
        append("createdBy=$createdBy,")
        append("createdResourceArn=$createdResourceArn,")
        append("creationDate=$creationDate,")
        append("deletionStatus=$deletionStatus,")
        append("deletionStatusMessage=$deletionStatusMessage,")
        append("expectedCompletionTimeMinutes=$expectedCompletionTimeMinutes,")
        append("iamRoleArn=$iamRoleArn,")
        append("percentDone=$percentDone,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("recoveryPointCreationDate=$recoveryPointCreationDate,")
        append("resourceType=$resourceType,")
        append("restoreJobId=$restoreJobId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("validationStatus=$validationStatus,")
        append("validationStatusMessage=$validationStatusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (backupSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (createdResourceArn?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (deletionStatus?.hashCode() ?: 0)
        result = 31 * result + (deletionStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (expectedCompletionTimeMinutes?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (percentDone?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointCreationDate?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (restoreJobId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (validationStatus?.hashCode() ?: 0)
        result = 31 * result + (validationStatusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreJobsListMember

        if (accountId != other.accountId) return false
        if (backupSizeInBytes != other.backupSizeInBytes) return false
        if (completionDate != other.completionDate) return false
        if (createdBy != other.createdBy) return false
        if (createdResourceArn != other.createdResourceArn) return false
        if (creationDate != other.creationDate) return false
        if (deletionStatus != other.deletionStatus) return false
        if (deletionStatusMessage != other.deletionStatusMessage) return false
        if (expectedCompletionTimeMinutes != other.expectedCompletionTimeMinutes) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (percentDone != other.percentDone) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (recoveryPointCreationDate != other.recoveryPointCreationDate) return false
        if (resourceType != other.resourceType) return false
        if (restoreJobId != other.restoreJobId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (validationStatus != other.validationStatus) return false
        if (validationStatusMessage != other.validationStatusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreJobsListMember = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The account ID that owns the restore job.
         */
        public var accountId: kotlin.String? = null
        /**
         * The size, in bytes, of the restored resource.
         */
        public var backupSizeInBytes: kotlin.Long? = null
        /**
         * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains identifying information about the creation of a restore job.
         */
        public var createdBy: aws.sdk.kotlin.services.backup.model.RestoreJobCreator? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var createdResourceArn: kotlin.String? = null
        /**
         * The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This notes the status of the data generated by the restore test. The status may be `Deleting`, `Failed`, or `Successful`.
         */
        public var deletionStatus: aws.sdk.kotlin.services.backup.model.RestoreDeletionStatus? = null
        /**
         * This describes the restore job deletion status.
         */
        public var deletionStatusMessage: kotlin.String? = null
        /**
         * The amount of time in minutes that a job restoring a recovery point is expected to take.
         */
        public var expectedCompletionTimeMinutes: kotlin.Long? = null
        /**
         * The IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * Contains an estimated percentage complete of a job at the time the job status was queried.
         */
        public var percentDone: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * The date on which a recovery point was created.
         */
        public var recoveryPointCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
         */
        public var resourceType: kotlin.String? = null
        /**
         * Uniquely identifies the job that restores a recovery point.
         */
        public var restoreJobId: kotlin.String? = null
        /**
         * A status code specifying the state of the job initiated by Backup to restore a recovery point.
         */
        public var status: aws.sdk.kotlin.services.backup.model.RestoreJobStatus? = null
        /**
         * A detailed message explaining the status of the job to restore a recovery point.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The status of validation run on the indicated restore job.
         */
        public var validationStatus: aws.sdk.kotlin.services.backup.model.RestoreValidationStatus? = null
        /**
         * This describes the status of validation run on the indicated restore job.
         */
        public var validationStatusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreJobsListMember) : this() {
            this.accountId = x.accountId
            this.backupSizeInBytes = x.backupSizeInBytes
            this.completionDate = x.completionDate
            this.createdBy = x.createdBy
            this.createdResourceArn = x.createdResourceArn
            this.creationDate = x.creationDate
            this.deletionStatus = x.deletionStatus
            this.deletionStatusMessage = x.deletionStatusMessage
            this.expectedCompletionTimeMinutes = x.expectedCompletionTimeMinutes
            this.iamRoleArn = x.iamRoleArn
            this.percentDone = x.percentDone
            this.recoveryPointArn = x.recoveryPointArn
            this.recoveryPointCreationDate = x.recoveryPointCreationDate
            this.resourceType = x.resourceType
            this.restoreJobId = x.restoreJobId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.validationStatus = x.validationStatus
            this.validationStatusMessage = x.validationStatusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreJobsListMember = RestoreJobsListMember(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RestoreJobCreator] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.backup.model.RestoreJobCreator.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.backup.model.RestoreJobCreator.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
