// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is a recovery point which is a child (nested) recovery point of a parent (composite) recovery point. These recovery points can be disassociated from their parent (composite) recovery point, in which case they will no longer be a member.
 */
public class RecoveryPointMember private constructor(builder: Builder) {
    /**
     * The name of the backup vault (the logical container in which backups are stored).
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies a saved resource.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The Amazon Web Services resource type that is saved as a recovery point.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RecoveryPointMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecoveryPointMember(")
        append("backupVaultName=$backupVaultName,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceArn=$resourceArn,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultName?.hashCode() ?: 0
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecoveryPointMember

        if (backupVaultName != other.backupVaultName) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RecoveryPointMember = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the backup vault (the logical container in which backups are stored).
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies a saved resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The Amazon Web Services resource type that is saved as a recovery point.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RecoveryPointMember) : this() {
            this.backupVaultName = x.backupVaultName
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceArn = x.resourceArn
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RecoveryPointMember = RecoveryPointMember(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
