// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about the recovery points stored in a backup vault.
 */
public class RecoveryPointByBackupVault private constructor(builder: Builder) {
    /**
     * The size, in bytes, of a backup.
     */
    public val backupSizeInBytes: kotlin.Long? = builder.backupSizeInBytes
    /**
     * An ARN that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * A `CalculatedLifecycle` object containing `DeleteAt` and `MoveToColdStorageAt` timestamps.
     */
    public val calculatedLifecycle: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle? = builder.calculatedLifecycle
    /**
     * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * The identifier of a resource within a composite group, such as nested (child) recovery point belonging to a composite (parent) stack. The ID is transferred from the [ logical ID](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax) within a stack.
     */
    public val compositeMemberIdentifier: kotlin.String? = builder.compositeMemberIdentifier
    /**
     * Contains identifying information about the creation of a recovery point, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan that is used to create it.
     */
    public val createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = builder.createdBy
    /**
     * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     */
    public val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn
    /**
     * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * This is the current status for the backup index associated with the specified recovery point.
     *
     * Statuses are: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
     *
     * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
     */
    public val indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = builder.indexStatus
    /**
     * A string in the form of a detailed message explaining the status of a backup index associated with the recovery point.
     */
    public val indexStatusMessage: kotlin.String? = builder.indexStatusMessage
    /**
     * The date and time when the backup job that created this recovery point was initiated, in Unix format and Coordinated Universal Time (UTC).
     */
    public val initiationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.initiationDate
    /**
     * A Boolean value that is returned as `TRUE` if the specified recovery point is encrypted, or `FALSE` if the recovery point is not encrypted.
     */
    public val isEncrypted: kotlin.Boolean = builder.isEncrypted
    /**
     * This is a boolean value indicating this is a parent (composite) recovery point.
     */
    public val isParent: kotlin.Boolean = builder.isParent
    /**
     * The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of `LastRestoreTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lastRestoreTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRestoreTime
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     */
    public val parentRecoveryPointArn: kotlin.String? = builder.parentRecoveryPointArn
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The non-unique name of the resource that belongs to the specified backup.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The backup vault where the recovery point was originally copied from. If the recovery point is restored to the same account this value will be `null`.
     */
    public val sourceBackupVaultArn: kotlin.String? = builder.sourceBackupVaultArn
    /**
     * A status code specifying the state of the recovery point.
     */
    public val status: aws.sdk.kotlin.services.backup.model.RecoveryPointStatus? = builder.status
    /**
     * A message explaining the current status of the recovery point.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The type of vault in which the described recovery point is stored.
     */
    public val vaultType: aws.sdk.kotlin.services.backup.model.VaultType? = builder.vaultType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RecoveryPointByBackupVault = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecoveryPointByBackupVault(")
        append("backupSizeInBytes=$backupSizeInBytes,")
        append("backupVaultArn=$backupVaultArn,")
        append("backupVaultName=$backupVaultName,")
        append("calculatedLifecycle=$calculatedLifecycle,")
        append("completionDate=$completionDate,")
        append("compositeMemberIdentifier=$compositeMemberIdentifier,")
        append("createdBy=$createdBy,")
        append("creationDate=$creationDate,")
        append("encryptionKeyArn=$encryptionKeyArn,")
        append("iamRoleArn=$iamRoleArn,")
        append("indexStatus=$indexStatus,")
        append("indexStatusMessage=$indexStatusMessage,")
        append("initiationDate=$initiationDate,")
        append("isEncrypted=$isEncrypted,")
        append("isParent=$isParent,")
        append("lastRestoreTime=$lastRestoreTime,")
        append("lifecycle=$lifecycle,")
        append("parentRecoveryPointArn=$parentRecoveryPointArn,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceArn=$resourceArn,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("sourceBackupVaultArn=$sourceBackupVaultArn,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("vaultType=$vaultType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupSizeInBytes?.hashCode() ?: 0
        result = 31 * result + (backupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (calculatedLifecycle?.hashCode() ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (compositeMemberIdentifier?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (indexStatus?.hashCode() ?: 0)
        result = 31 * result + (indexStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (initiationDate?.hashCode() ?: 0)
        result = 31 * result + (isEncrypted.hashCode())
        result = 31 * result + (isParent.hashCode())
        result = 31 * result + (lastRestoreTime?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (parentRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (vaultType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecoveryPointByBackupVault

        if (backupSizeInBytes != other.backupSizeInBytes) return false
        if (backupVaultArn != other.backupVaultArn) return false
        if (backupVaultName != other.backupVaultName) return false
        if (calculatedLifecycle != other.calculatedLifecycle) return false
        if (completionDate != other.completionDate) return false
        if (compositeMemberIdentifier != other.compositeMemberIdentifier) return false
        if (createdBy != other.createdBy) return false
        if (creationDate != other.creationDate) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (indexStatus != other.indexStatus) return false
        if (indexStatusMessage != other.indexStatusMessage) return false
        if (initiationDate != other.initiationDate) return false
        if (isEncrypted != other.isEncrypted) return false
        if (isParent != other.isParent) return false
        if (lastRestoreTime != other.lastRestoreTime) return false
        if (lifecycle != other.lifecycle) return false
        if (parentRecoveryPointArn != other.parentRecoveryPointArn) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (sourceBackupVaultArn != other.sourceBackupVaultArn) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (vaultType != other.vaultType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RecoveryPointByBackupVault = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The size, in bytes, of a backup.
         */
        public var backupSizeInBytes: kotlin.Long? = null
        /**
         * An ARN that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * A `CalculatedLifecycle` object containing `DeleteAt` and `MoveToColdStorageAt` timestamps.
         */
        public var calculatedLifecycle: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle? = null
        /**
         * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of a resource within a composite group, such as nested (child) recovery point belonging to a composite (parent) stack. The ID is transferred from the [ logical ID](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax) within a stack.
         */
        public var compositeMemberIdentifier: kotlin.String? = null
        /**
         * Contains identifying information about the creation of a recovery point, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan that is used to create it.
         */
        public var createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = null
        /**
         * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         */
        public var encryptionKeyArn: kotlin.String? = null
        /**
         * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * This is the current status for the backup index associated with the specified recovery point.
         *
         * Statuses are: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
         *
         * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
         */
        public var indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = null
        /**
         * A string in the form of a detailed message explaining the status of a backup index associated with the recovery point.
         */
        public var indexStatusMessage: kotlin.String? = null
        /**
         * The date and time when the backup job that created this recovery point was initiated, in Unix format and Coordinated Universal Time (UTC).
         */
        public var initiationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A Boolean value that is returned as `TRUE` if the specified recovery point is encrypted, or `FALSE` if the recovery point is not encrypted.
         */
        public var isEncrypted: kotlin.Boolean = false
        /**
         * This is a boolean value indicating this is a parent (composite) recovery point.
         */
        public var isParent: kotlin.Boolean = false
        /**
         * The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of `LastRestoreTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lastRestoreTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         */
        public var parentRecoveryPointArn: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The non-unique name of the resource that belongs to the specified backup.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The backup vault where the recovery point was originally copied from. If the recovery point is restored to the same account this value will be `null`.
         */
        public var sourceBackupVaultArn: kotlin.String? = null
        /**
         * A status code specifying the state of the recovery point.
         */
        public var status: aws.sdk.kotlin.services.backup.model.RecoveryPointStatus? = null
        /**
         * A message explaining the current status of the recovery point.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The type of vault in which the described recovery point is stored.
         */
        public var vaultType: aws.sdk.kotlin.services.backup.model.VaultType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RecoveryPointByBackupVault) : this() {
            this.backupSizeInBytes = x.backupSizeInBytes
            this.backupVaultArn = x.backupVaultArn
            this.backupVaultName = x.backupVaultName
            this.calculatedLifecycle = x.calculatedLifecycle
            this.completionDate = x.completionDate
            this.compositeMemberIdentifier = x.compositeMemberIdentifier
            this.createdBy = x.createdBy
            this.creationDate = x.creationDate
            this.encryptionKeyArn = x.encryptionKeyArn
            this.iamRoleArn = x.iamRoleArn
            this.indexStatus = x.indexStatus
            this.indexStatusMessage = x.indexStatusMessage
            this.initiationDate = x.initiationDate
            this.isEncrypted = x.isEncrypted
            this.isParent = x.isParent
            this.lastRestoreTime = x.lastRestoreTime
            this.lifecycle = x.lifecycle
            this.parentRecoveryPointArn = x.parentRecoveryPointArn
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceArn = x.resourceArn
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.sourceBackupVaultArn = x.sourceBackupVaultArn
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.vaultType = x.vaultType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RecoveryPointByBackupVault = RecoveryPointByBackupVault(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.CalculatedLifecycle] inside the given [block]
         */
        public fun calculatedLifecycle(block: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle.Builder.() -> kotlin.Unit) {
            this.calculatedLifecycle = aws.sdk.kotlin.services.backup.model.CalculatedLifecycle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RecoveryPointCreator] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
