// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains detailed information about all of the controls of a framework. Each framework must contain at least one control.
 */
public class FrameworkControl private constructor(builder: Builder) {
    /**
     * The name/value pairs.
     */
    public val controlInputParameters: List<ControlInputParameter>? = builder.controlInputParameters
    /**
     * The name of a control. This name is between 1 and 256 characters.
     */
    public val controlName: kotlin.String = requireNotNull(builder.controlName) { "A non-null value must be provided for controlName" }
    /**
     * The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
     *
     * For more information, see `ControlScope`[.](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html)
     */
    public val controlScope: aws.sdk.kotlin.services.backup.model.ControlScope? = builder.controlScope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.FrameworkControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FrameworkControl(")
        append("controlInputParameters=$controlInputParameters,")
        append("controlName=$controlName,")
        append("controlScope=$controlScope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlInputParameters?.hashCode() ?: 0
        result = 31 * result + (controlName.hashCode())
        result = 31 * result + (controlScope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FrameworkControl

        if (controlInputParameters != other.controlInputParameters) return false
        if (controlName != other.controlName) return false
        if (controlScope != other.controlScope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.FrameworkControl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name/value pairs.
         */
        public var controlInputParameters: List<ControlInputParameter>? = null
        /**
         * The name of a control. This name is between 1 and 256 characters.
         */
        public var controlName: kotlin.String? = null
        /**
         * The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
         *
         * For more information, see `ControlScope`[.](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html)
         */
        public var controlScope: aws.sdk.kotlin.services.backup.model.ControlScope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.FrameworkControl) : this() {
            this.controlInputParameters = x.controlInputParameters
            this.controlName = x.controlName
            this.controlScope = x.controlScope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.FrameworkControl = FrameworkControl(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.ControlScope] inside the given [block]
         */
        public fun controlScope(block: aws.sdk.kotlin.services.backup.model.ControlScope.Builder.() -> kotlin.Unit) {
            this.controlScope = aws.sdk.kotlin.services.backup.model.ControlScope.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (controlName == null) controlName = ""
            return this
        }
    }
}
