// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about a framework. Frameworks contain controls, which evaluate and report on your backup events and resources. Frameworks generate daily compliance results.
 */
public class Framework private constructor(builder: Builder) {
    /**
     * The date and time that a framework is created, in ISO 8601 representation. The value of `CreationTime` is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The deployment status of a framework. The statuses are:
     *
     * `CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED`
     */
    public val deploymentStatus: kotlin.String? = builder.deploymentStatus
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val frameworkArn: kotlin.String? = builder.frameworkArn
    /**
     * An optional description of the framework with a maximum 1,024 characters.
     */
    public val frameworkDescription: kotlin.String? = builder.frameworkDescription
    /**
     * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public val frameworkName: kotlin.String? = builder.frameworkName
    /**
     * The number of controls contained by the framework.
     */
    public val numberOfControls: kotlin.Int = builder.numberOfControls

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.Framework = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Framework(")
        append("creationTime=$creationTime,")
        append("deploymentStatus=$deploymentStatus,")
        append("frameworkArn=$frameworkArn,")
        append("frameworkDescription=$frameworkDescription,")
        append("frameworkName=$frameworkName,")
        append("numberOfControls=$numberOfControls")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (frameworkArn?.hashCode() ?: 0)
        result = 31 * result + (frameworkDescription?.hashCode() ?: 0)
        result = 31 * result + (frameworkName?.hashCode() ?: 0)
        result = 31 * result + (numberOfControls)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Framework

        if (creationTime != other.creationTime) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (frameworkArn != other.frameworkArn) return false
        if (frameworkDescription != other.frameworkDescription) return false
        if (frameworkName != other.frameworkName) return false
        if (numberOfControls != other.numberOfControls) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.Framework = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that a framework is created, in ISO 8601 representation. The value of `CreationTime` is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The deployment status of a framework. The statuses are:
         *
         * `CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED`
         */
        public var deploymentStatus: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var frameworkArn: kotlin.String? = null
        /**
         * An optional description of the framework with a maximum 1,024 characters.
         */
        public var frameworkDescription: kotlin.String? = null
        /**
         * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         */
        public var frameworkName: kotlin.String? = null
        /**
         * The number of controls contained by the framework.
         */
        public var numberOfControls: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.Framework) : this() {
            this.creationTime = x.creationTime
            this.deploymentStatus = x.deploymentStatus
            this.frameworkArn = x.frameworkArn
            this.frameworkDescription = x.frameworkDescription
            this.frameworkName = x.frameworkName
            this.numberOfControls = x.numberOfControls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.Framework = Framework(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
