// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateLogicallyAirGappedBackupVaultRequest private constructor(builder: Builder) {
    /**
     * The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The tags to assign to the vault.
     */
    public val backupVaultTags: Map<String, String>? = builder.backupVaultTags
    /**
     * The ID of the creation request.
     *
     * This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The maximum retention period that the vault retains its recovery points.
     */
    public val maxRetentionDays: kotlin.Long? = builder.maxRetentionDays
    /**
     * This setting specifies the minimum retention period that the vault retains its recovery points.
     *
     * The minimum value accepted is 7 days.
     */
    public val minRetentionDays: kotlin.Long? = builder.minRetentionDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLogicallyAirGappedBackupVaultRequest(")
        append("backupVaultName=$backupVaultName,")
        append("backupVaultTags=*** Sensitive Data Redacted ***,")
        append("creatorRequestId=$creatorRequestId,")
        append("maxRetentionDays=$maxRetentionDays,")
        append("minRetentionDays=$minRetentionDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultName?.hashCode() ?: 0
        result = 31 * result + (backupVaultTags?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (maxRetentionDays?.hashCode() ?: 0)
        result = 31 * result + (minRetentionDays?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLogicallyAirGappedBackupVaultRequest

        if (backupVaultName != other.backupVaultName) return false
        if (backupVaultTags != other.backupVaultTags) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (maxRetentionDays != other.maxRetentionDays) return false
        if (minRetentionDays != other.minRetentionDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The tags to assign to the vault.
         */
        public var backupVaultTags: Map<String, String>? = null
        /**
         * The ID of the creation request.
         *
         * This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The maximum retention period that the vault retains its recovery points.
         */
        public var maxRetentionDays: kotlin.Long? = null
        /**
         * This setting specifies the minimum retention period that the vault retains its recovery points.
         *
         * The minimum value accepted is 7 days.
         */
        public var minRetentionDays: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest) : this() {
            this.backupVaultName = x.backupVaultName
            this.backupVaultTags = x.backupVaultTags
            this.creatorRequestId = x.creatorRequestId
            this.maxRetentionDays = x.maxRetentionDays
            this.minRetentionDays = x.minRetentionDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest = CreateLogicallyAirGappedBackupVaultRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
