// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies a scheduled task used to back up a selection of resources.
 */
public class BackupRuleInput private constructor(builder: Builder) {
    /**
     * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
     */
    public val completionWindowMinutes: kotlin.Long? = builder.completionWindowMinutes
    /**
     * An array of `CopyAction` objects, which contains the details of the copy operation.
     */
    public val copyActions: List<CopyAction>? = builder.copyActions
    /**
     * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
     */
    public val enableContinuousBackup: kotlin.Boolean? = builder.enableContinuousBackup
    /**
     * There can up to one IndexAction in each BackupRule, as each backup can have 0 or 1 backup index associated with it.
     *
     * Within the array is ResourceTypes. Only 1 resource type will be accepted for each BackupRule. Valid values:
     * + `EBS` for Amazon Elastic Block Store
     * + `S3` for Amazon Simple Storage Service (Amazon S3)
     */
    public val indexActions: List<IndexAction>? = builder.indexActions
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold storage.
     *
     * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
     *
     * This parameter has a maximum value of 100 years (36,500 days).
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * The tags to assign to the resources.
     */
    public val recoveryPointTags: Map<String, String>? = builder.recoveryPointTags
    /**
     * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val ruleName: kotlin.String = requireNotNull(builder.ruleName) { "A non-null value must be provided for ruleName" }
    /**
     * A CRON expression in UTC specifying when Backup initiates a backup job. When no CRON expression is provided, Backup will use the default expression `cron(0 5 ? * * *)`.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
     */
    public val scheduleExpressionTimezone: kotlin.String? = builder.scheduleExpressionTimezone
    /**
     * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.
     *
     * This parameter has a maximum value of 100 years (52,560,000 minutes).
     *
     * During the start window, the backup job status remains in `CREATED` status until it has successfully begun or until the start window time has run out. If within the start window time Backup receives an error that allows the job to be retried, Backup will automatically retry to begin the job at least every 10 minutes until the backup successfully begins (the job status changes to `RUNNING`) or until the job status changes to `EXPIRED` (which is expected to occur when the start window time is over).
     */
    public val startWindowMinutes: kotlin.Long? = builder.startWindowMinutes
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created.
     */
    public val targetBackupVaultName: kotlin.String = requireNotNull(builder.targetBackupVaultName) { "A non-null value must be provided for targetBackupVaultName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupRuleInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupRuleInput(")
        append("completionWindowMinutes=$completionWindowMinutes,")
        append("copyActions=$copyActions,")
        append("enableContinuousBackup=$enableContinuousBackup,")
        append("indexActions=$indexActions,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointTags=*** Sensitive Data Redacted ***,")
        append("ruleName=$ruleName,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleExpressionTimezone=$scheduleExpressionTimezone,")
        append("startWindowMinutes=$startWindowMinutes,")
        append("targetBackupVaultName=$targetBackupVaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionWindowMinutes?.hashCode() ?: 0
        result = 31 * result + (copyActions?.hashCode() ?: 0)
        result = 31 * result + (enableContinuousBackup?.hashCode() ?: 0)
        result = 31 * result + (indexActions?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointTags?.hashCode() ?: 0)
        result = 31 * result + (ruleName.hashCode())
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpressionTimezone?.hashCode() ?: 0)
        result = 31 * result + (startWindowMinutes?.hashCode() ?: 0)
        result = 31 * result + (targetBackupVaultName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupRuleInput

        if (completionWindowMinutes != other.completionWindowMinutes) return false
        if (copyActions != other.copyActions) return false
        if (enableContinuousBackup != other.enableContinuousBackup) return false
        if (indexActions != other.indexActions) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointTags != other.recoveryPointTags) return false
        if (ruleName != other.ruleName) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleExpressionTimezone != other.scheduleExpressionTimezone) return false
        if (startWindowMinutes != other.startWindowMinutes) return false
        if (targetBackupVaultName != other.targetBackupVaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupRuleInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
         */
        public var completionWindowMinutes: kotlin.Long? = null
        /**
         * An array of `CopyAction` objects, which contains the details of the copy operation.
         */
        public var copyActions: List<CopyAction>? = null
        /**
         * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
         */
        public var enableContinuousBackup: kotlin.Boolean? = null
        /**
         * There can up to one IndexAction in each BackupRule, as each backup can have 0 or 1 backup index associated with it.
         *
         * Within the array is ResourceTypes. Only 1 resource type will be accepted for each BackupRule. Valid values:
         * + `EBS` for Amazon Elastic Block Store
         * + `S3` for Amazon Simple Storage Service (Amazon S3)
         */
        public var indexActions: List<IndexAction>? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold storage.
         *
         * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
         *
         * This parameter has a maximum value of 100 years (36,500 days).
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * The tags to assign to the resources.
         */
        public var recoveryPointTags: Map<String, String>? = null
        /**
         * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var ruleName: kotlin.String? = null
        /**
         * A CRON expression in UTC specifying when Backup initiates a backup job. When no CRON expression is provided, Backup will use the default expression `cron(0 5 ? * * *)`.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * The timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         */
        public var scheduleExpressionTimezone: kotlin.String? = null
        /**
         * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.
         *
         * This parameter has a maximum value of 100 years (52,560,000 minutes).
         *
         * During the start window, the backup job status remains in `CREATED` status until it has successfully begun or until the start window time has run out. If within the start window time Backup receives an error that allows the job to be retried, Backup will automatically retry to begin the job at least every 10 minutes until the backup successfully begins (the job status changes to `RUNNING`) or until the job status changes to `EXPIRED` (which is expected to occur when the start window time is over).
         */
        public var startWindowMinutes: kotlin.Long? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created.
         */
        public var targetBackupVaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupRuleInput) : this() {
            this.completionWindowMinutes = x.completionWindowMinutes
            this.copyActions = x.copyActions
            this.enableContinuousBackup = x.enableContinuousBackup
            this.indexActions = x.indexActions
            this.lifecycle = x.lifecycle
            this.recoveryPointTags = x.recoveryPointTags
            this.ruleName = x.ruleName
            this.scheduleExpression = x.scheduleExpression
            this.scheduleExpressionTimezone = x.scheduleExpressionTimezone
            this.startWindowMinutes = x.startWindowMinutes
            this.targetBackupVaultName = x.targetBackupVaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupRuleInput = BackupRuleInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (ruleName == null) ruleName = ""
            if (targetBackupVaultName == null) targetBackupVaultName = ""
            return this
        }
    }
}
