// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.GetRecoveryPointIndexDetailsResponse
import aws.sdk.kotlin.services.backup.model.IndexStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetRecoveryPointIndexDetailsOperationDeserializer: HttpDeserializer.NonStreaming<GetRecoveryPointIndexDetailsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRecoveryPointIndexDetailsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRecoveryPointIndexDetailsError(context, call, payload)
        }
        val builder = GetRecoveryPointIndexDetailsResponse.Builder()

        if (payload != null) {
            deserializeGetRecoveryPointIndexDetailsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRecoveryPointIndexDetailsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecoveryPointIndexDetailsOperationBody(builder: GetRecoveryPointIndexDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val INDEXCOMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("IndexCompletionDate"))
    val INDEXCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("IndexCreationDate"))
    val INDEXDELETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("IndexDeletionDate"))
    val INDEXSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IndexStatus"))
    val INDEXSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexStatusMessage"))
    val RECOVERYPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecoveryPointArn"))
    val SOURCERESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceResourceArn"))
    val TOTALITEMSINDEXED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("TotalItemsIndexed"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(INDEXCOMPLETIONDATE_DESCRIPTOR)
        field(INDEXCREATIONDATE_DESCRIPTOR)
        field(INDEXDELETIONDATE_DESCRIPTOR)
        field(INDEXSTATUS_DESCRIPTOR)
        field(INDEXSTATUSMESSAGE_DESCRIPTOR)
        field(RECOVERYPOINTARN_DESCRIPTOR)
        field(SOURCERESOURCEARN_DESCRIPTOR)
        field(TOTALITEMSINDEXED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                INDEXCOMPLETIONDATE_DESCRIPTOR.index -> builder.indexCompletionDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                INDEXCREATIONDATE_DESCRIPTOR.index -> builder.indexCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                INDEXDELETIONDATE_DESCRIPTOR.index -> builder.indexDeletionDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                INDEXSTATUS_DESCRIPTOR.index -> builder.indexStatus = deserializeString().let { IndexStatus.fromValue(it) }
                INDEXSTATUSMESSAGE_DESCRIPTOR.index -> builder.indexStatusMessage = deserializeString()
                RECOVERYPOINTARN_DESCRIPTOR.index -> builder.recoveryPointArn = deserializeString()
                SOURCERESOURCEARN_DESCRIPTOR.index -> builder.sourceResourceArn = deserializeString()
                TOTALITEMSINDEXED_DESCRIPTOR.index -> builder.totalItemsIndexed = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
