// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.DeleteBackupPlanResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DeleteBackupPlanOperationDeserializer: HttpDeserializer.NonStreaming<DeleteBackupPlanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteBackupPlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteBackupPlanError(context, call, payload)
        }
        val builder = DeleteBackupPlanResponse.Builder()

        if (payload != null) {
            deserializeDeleteBackupPlanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteBackupPlanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteBackupPlanOperationBody(builder: DeleteBackupPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPPLANARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupPlanArn"))
    val BACKUPPLANID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupPlanId"))
    val DELETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DeletionDate"))
    val VERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPPLANARN_DESCRIPTOR)
        field(BACKUPPLANID_DESCRIPTOR)
        field(DELETIONDATE_DESCRIPTOR)
        field(VERSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPPLANARN_DESCRIPTOR.index -> builder.backupPlanArn = deserializeString()
                BACKUPPLANID_DESCRIPTOR.index -> builder.backupPlanId = deserializeString()
                DELETIONDATE_DESCRIPTOR.index -> builder.deletionDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                VERSIONID_DESCRIPTOR.index -> builder.versionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
