// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateRecoveryPointLifecycleResponse private constructor(builder: Builder) {
    /**
     * An ARN that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * A `CalculatedLifecycle` object containing `DeleteAt` and `MoveToColdStorageAt` timestamps.
     */
    public val calculatedLifecycle: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle? = builder.calculatedLifecycle
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRecoveryPointLifecycleResponse(")
        append("backupVaultArn=$backupVaultArn,")
        append("calculatedLifecycle=$calculatedLifecycle,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointArn=$recoveryPointArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultArn?.hashCode() ?: 0
        result = 31 * result + (calculatedLifecycle?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRecoveryPointLifecycleResponse

        if (backupVaultArn != other.backupVaultArn) return false
        if (calculatedLifecycle != other.calculatedLifecycle) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointArn != other.recoveryPointArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An ARN that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * A `CalculatedLifecycle` object containing `DeleteAt` and `MoveToColdStorageAt` timestamps.
         */
        public var calculatedLifecycle: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleResponse) : this() {
            this.backupVaultArn = x.backupVaultArn
            this.calculatedLifecycle = x.calculatedLifecycle
            this.lifecycle = x.lifecycle
            this.recoveryPointArn = x.recoveryPointArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleResponse = UpdateRecoveryPointLifecycleResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.CalculatedLifecycle] inside the given [block]
         */
        public fun calculatedLifecycle(block: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle.Builder.() -> kotlin.Unit) {
            this.calculatedLifecycle = aws.sdk.kotlin.services.backup.model.CalculatedLifecycle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
