// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This contains metadata about a restore testing selection.
 */
public class RestoreTestingSelectionForUpdate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * You can include a list of specific ARNs, such as `ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]` or you can include a wildcard: `ProtectedResourceArns: ["*"]`, but not both.
     */
    public val protectedResourceArns: List<String>? = builder.protectedResourceArns
    /**
     * The conditions that you define for resources in your restore testing plan using tags.
     */
    public val protectedResourceConditions: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions? = builder.protectedResourceConditions
    /**
     * You can override certain restore metadata keys by including the parameter `RestoreMetadataOverrides` in the body of `RestoreTestingSelection`. Key values are not case sensitive.
     *
     * See the complete list of [restore testing inferred metadata](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
     */
    public val restoreMetadataOverrides: Map<String, String>? = builder.restoreMetadataOverrides
    /**
     * This value represents the time, in hours, data is retained after a restore test so that optional validation can be completed.
     *
     * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
     */
    public val validationWindowHours: kotlin.Int = builder.validationWindowHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingSelectionForUpdate(")
        append("iamRoleArn=$iamRoleArn,")
        append("protectedResourceArns=$protectedResourceArns,")
        append("protectedResourceConditions=$protectedResourceConditions,")
        append("restoreMetadataOverrides=*** Sensitive Data Redacted ***,")
        append("validationWindowHours=$validationWindowHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iamRoleArn?.hashCode() ?: 0
        result = 31 * result + (protectedResourceArns?.hashCode() ?: 0)
        result = 31 * result + (protectedResourceConditions?.hashCode() ?: 0)
        result = 31 * result + (restoreMetadataOverrides?.hashCode() ?: 0)
        result = 31 * result + (validationWindowHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingSelectionForUpdate

        if (iamRoleArn != other.iamRoleArn) return false
        if (protectedResourceArns != other.protectedResourceArns) return false
        if (protectedResourceConditions != other.protectedResourceConditions) return false
        if (restoreMetadataOverrides != other.restoreMetadataOverrides) return false
        if (validationWindowHours != other.validationWindowHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * You can include a list of specific ARNs, such as `ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]` or you can include a wildcard: `ProtectedResourceArns: ["*"]`, but not both.
         */
        public var protectedResourceArns: List<String>? = null
        /**
         * The conditions that you define for resources in your restore testing plan using tags.
         */
        public var protectedResourceConditions: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions? = null
        /**
         * You can override certain restore metadata keys by including the parameter `RestoreMetadataOverrides` in the body of `RestoreTestingSelection`. Key values are not case sensitive.
         *
         * See the complete list of [restore testing inferred metadata](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
         */
        public var restoreMetadataOverrides: Map<String, String>? = null
        /**
         * This value represents the time, in hours, data is retained after a restore test so that optional validation can be completed.
         *
         * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
         */
        public var validationWindowHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForUpdate) : this() {
            this.iamRoleArn = x.iamRoleArn
            this.protectedResourceArns = x.protectedResourceArns
            this.protectedResourceConditions = x.protectedResourceConditions
            this.restoreMetadataOverrides = x.restoreMetadataOverrides
            this.validationWindowHours = x.validationWindowHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForUpdate = RestoreTestingSelectionForUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions] inside the given [block]
         */
        public fun protectedResourceConditions(block: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions.Builder.() -> kotlin.Unit) {
            this.protectedResourceConditions = aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
