// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about a report plan.
 */
public class ReportPlan private constructor(builder: Builder) {
    /**
     * The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The deployment status of a report plan. The statuses are:
     *
     * `CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED`
     */
    public val deploymentStatus: kotlin.String? = builder.deploymentStatus
    /**
     * The date and time that a report job associated with this report plan last attempted to run, in Unix format and Coordinated Universal Time (UTC). The value of `LastAttemptedExecutionTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lastAttemptedExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAttemptedExecutionTime
    /**
     * The date and time that a report job associated with this report plan last successfully ran, in Unix format and Coordinated Universal Time (UTC). The value of `LastSuccessfulExecutionTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lastSuccessfulExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulExecutionTime
    /**
     * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
     */
    public val reportDeliveryChannel: aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel? = builder.reportDeliveryChannel
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val reportPlanArn: kotlin.String? = builder.reportPlanArn
    /**
     * An optional description of the report plan with a maximum 1,024 characters.
     */
    public val reportPlanDescription: kotlin.String? = builder.reportPlanDescription
    /**
     * The unique name of the report plan. This name is between 1 and 256 characters starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public val reportPlanName: kotlin.String? = builder.reportPlanName
    /**
     * Identifies the report template for the report. Reports are built using a report template. The report templates are:
     *
     * `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
     *
     * If the report template is `RESOURCE_COMPLIANCE_REPORT` or `CONTROL_COMPLIANCE_REPORT`, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
     */
    public val reportSetting: aws.sdk.kotlin.services.backup.model.ReportSetting? = builder.reportSetting

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ReportPlan = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportPlan(")
        append("creationTime=$creationTime,")
        append("deploymentStatus=$deploymentStatus,")
        append("lastAttemptedExecutionTime=$lastAttemptedExecutionTime,")
        append("lastSuccessfulExecutionTime=$lastSuccessfulExecutionTime,")
        append("reportDeliveryChannel=$reportDeliveryChannel,")
        append("reportPlanArn=$reportPlanArn,")
        append("reportPlanDescription=$reportPlanDescription,")
        append("reportPlanName=$reportPlanName,")
        append("reportSetting=$reportSetting")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (lastAttemptedExecutionTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulExecutionTime?.hashCode() ?: 0)
        result = 31 * result + (reportDeliveryChannel?.hashCode() ?: 0)
        result = 31 * result + (reportPlanArn?.hashCode() ?: 0)
        result = 31 * result + (reportPlanDescription?.hashCode() ?: 0)
        result = 31 * result + (reportPlanName?.hashCode() ?: 0)
        result = 31 * result + (reportSetting?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportPlan

        if (creationTime != other.creationTime) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (lastAttemptedExecutionTime != other.lastAttemptedExecutionTime) return false
        if (lastSuccessfulExecutionTime != other.lastSuccessfulExecutionTime) return false
        if (reportDeliveryChannel != other.reportDeliveryChannel) return false
        if (reportPlanArn != other.reportPlanArn) return false
        if (reportPlanDescription != other.reportPlanDescription) return false
        if (reportPlanName != other.reportPlanName) return false
        if (reportSetting != other.reportSetting) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ReportPlan = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The deployment status of a report plan. The statuses are:
         *
         * `CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED`
         */
        public var deploymentStatus: kotlin.String? = null
        /**
         * The date and time that a report job associated with this report plan last attempted to run, in Unix format and Coordinated Universal Time (UTC). The value of `LastAttemptedExecutionTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lastAttemptedExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that a report job associated with this report plan last successfully ran, in Unix format and Coordinated Universal Time (UTC). The value of `LastSuccessfulExecutionTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lastSuccessfulExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
         */
        public var reportDeliveryChannel: aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var reportPlanArn: kotlin.String? = null
        /**
         * An optional description of the report plan with a maximum 1,024 characters.
         */
        public var reportPlanDescription: kotlin.String? = null
        /**
         * The unique name of the report plan. This name is between 1 and 256 characters starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         */
        public var reportPlanName: kotlin.String? = null
        /**
         * Identifies the report template for the report. Reports are built using a report template. The report templates are:
         *
         * `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
         *
         * If the report template is `RESOURCE_COMPLIANCE_REPORT` or `CONTROL_COMPLIANCE_REPORT`, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
         */
        public var reportSetting: aws.sdk.kotlin.services.backup.model.ReportSetting? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ReportPlan) : this() {
            this.creationTime = x.creationTime
            this.deploymentStatus = x.deploymentStatus
            this.lastAttemptedExecutionTime = x.lastAttemptedExecutionTime
            this.lastSuccessfulExecutionTime = x.lastSuccessfulExecutionTime
            this.reportDeliveryChannel = x.reportDeliveryChannel
            this.reportPlanArn = x.reportPlanArn
            this.reportPlanDescription = x.reportPlanDescription
            this.reportPlanName = x.reportPlanName
            this.reportSetting = x.reportSetting
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ReportPlan = ReportPlan(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel] inside the given [block]
         */
        public fun reportDeliveryChannel(block: aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel.Builder.() -> kotlin.Unit) {
            this.reportDeliveryChannel = aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.ReportSetting] inside the given [block]
         */
        public fun reportSetting(block: aws.sdk.kotlin.services.backup.model.ReportSetting.Builder.() -> kotlin.Unit) {
            this.reportSetting = aws.sdk.kotlin.services.backup.model.ReportSetting.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
