// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutBackupVaultLockConfigurationRequest private constructor(builder: Builder) {
    /**
     * The Backup Vault Lock configuration that specifies the name of the backup vault it protects.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting `ChangeableForDays` to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.
     *
     * Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set `ChangeableForDays` to 3 or greater.
     *
     * Before the lock date, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration`. On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.
     *
     * If this parameter is not specified, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` at any time.
     */
    public val changeableForDays: kotlin.Long? = builder.changeableForDays
    /**
     * The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).
     *
     * If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.
     *
     * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. The longest maximum retention period you can specify is 36500 days (approximately 100 years). Recovery points already saved in the vault prior to Vault Lock are not affected.
     */
    public val maxRetentionDays: kotlin.Long? = builder.maxRetentionDays
    /**
     * The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).
     *
     * This parameter is required when a vault lock is created through CloudFormation; otherwise, this parameter is optional. If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
     *
     * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. The shortest minimum retention period you can specify is 1 day. Recovery points already saved in the vault prior to Vault Lock are not affected.
     */
    public val minRetentionDays: kotlin.Long? = builder.minRetentionDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.PutBackupVaultLockConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBackupVaultLockConfigurationRequest(")
        append("backupVaultName=$backupVaultName,")
        append("changeableForDays=$changeableForDays,")
        append("maxRetentionDays=$maxRetentionDays,")
        append("minRetentionDays=$minRetentionDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultName?.hashCode() ?: 0
        result = 31 * result + (changeableForDays?.hashCode() ?: 0)
        result = 31 * result + (maxRetentionDays?.hashCode() ?: 0)
        result = 31 * result + (minRetentionDays?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBackupVaultLockConfigurationRequest

        if (backupVaultName != other.backupVaultName) return false
        if (changeableForDays != other.changeableForDays) return false
        if (maxRetentionDays != other.maxRetentionDays) return false
        if (minRetentionDays != other.minRetentionDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.PutBackupVaultLockConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Backup Vault Lock configuration that specifies the name of the backup vault it protects.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting `ChangeableForDays` to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.
         *
         * Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set `ChangeableForDays` to 3 or greater.
         *
         * Before the lock date, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration`. On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.
         *
         * If this parameter is not specified, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` at any time.
         */
        public var changeableForDays: kotlin.Long? = null
        /**
         * The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).
         *
         * If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.
         *
         * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. The longest maximum retention period you can specify is 36500 days (approximately 100 years). Recovery points already saved in the vault prior to Vault Lock are not affected.
         */
        public var maxRetentionDays: kotlin.Long? = null
        /**
         * The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).
         *
         * This parameter is required when a vault lock is created through CloudFormation; otherwise, this parameter is optional. If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
         *
         * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. The shortest minimum retention period you can specify is 1 day. Recovery points already saved in the vault prior to Vault Lock are not affected.
         */
        public var minRetentionDays: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.PutBackupVaultLockConfigurationRequest) : this() {
            this.backupVaultName = x.backupVaultName
            this.changeableForDays = x.changeableForDays
            this.maxRetentionDays = x.maxRetentionDays
            this.minRetentionDays = x.minRetentionDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.PutBackupVaultLockConfigurationRequest = PutBackupVaultLockConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
