// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListIndexedRecoveryPointsRequest private constructor(builder: Builder) {
    /**
     * Returns only indexed recovery points that were created after the specified date.
     */
    public val createdAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAfter
    /**
     * Returns only indexed recovery points that were created before the specified date.
     */
    public val createdBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.createdBefore
    /**
     * Include this parameter to filter the returned list by the indicated statuses.
     *
     * Accepted values: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
     *
     * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
     */
    public val indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = builder.indexStatus
    /**
     * The maximum number of resource list items to be returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The next item following a partial list of returned recovery points.
     *
     * For example, if a request is made to return `MaxResults` number of indexed recovery points, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Returns a list of indexed recovery points for the specified resource type(s).
     *
     * Accepted values include:
     * + `EBS` for Amazon Elastic Block Store
     * + `S3` for Amazon Simple Storage Service (Amazon S3)
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
     */
    public val sourceResourceArn: kotlin.String? = builder.sourceResourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListIndexedRecoveryPointsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListIndexedRecoveryPointsRequest(")
        append("createdAfter=$createdAfter,")
        append("createdBefore=$createdBefore,")
        append("indexStatus=$indexStatus,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceType=$resourceType,")
        append("sourceResourceArn=$sourceResourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAfter?.hashCode() ?: 0
        result = 31 * result + (createdBefore?.hashCode() ?: 0)
        result = 31 * result + (indexStatus?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceResourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListIndexedRecoveryPointsRequest

        if (createdAfter != other.createdAfter) return false
        if (createdBefore != other.createdBefore) return false
        if (indexStatus != other.indexStatus) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceType != other.resourceType) return false
        if (sourceResourceArn != other.sourceResourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListIndexedRecoveryPointsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns only indexed recovery points that were created after the specified date.
         */
        public var createdAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only indexed recovery points that were created before the specified date.
         */
        public var createdBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Include this parameter to filter the returned list by the indicated statuses.
         *
         * Accepted values: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
         *
         * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
         */
        public var indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = null
        /**
         * The maximum number of resource list items to be returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The next item following a partial list of returned recovery points.
         *
         * For example, if a request is made to return `MaxResults` number of indexed recovery points, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Returns a list of indexed recovery points for the specified resource type(s).
         *
         * Accepted values include:
         * + `EBS` for Amazon Elastic Block Store
         * + `S3` for Amazon Simple Storage Service (Amazon S3)
         */
        public var resourceType: kotlin.String? = null
        /**
         * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
         */
        public var sourceResourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListIndexedRecoveryPointsRequest) : this() {
            this.createdAfter = x.createdAfter
            this.createdBefore = x.createdBefore
            this.indexStatus = x.indexStatus
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceType = x.resourceType
            this.sourceResourceArn = x.sourceResourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListIndexedRecoveryPointsRequest = ListIndexedRecoveryPointsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
