// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the time period, in days, before a recovery point transitions to cold storage or is deleted.
 *
 * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the retention setting must be 90 days greater than the transition to cold after days setting. The transition to cold after days setting can't be changed after a backup has been transitioned to cold.
 *
 * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
 *
 * To remove the existing lifecycle and retention periods and keep your recovery points indefinitely, specify -1 for `MoveToColdStorageAfterDays` and `DeleteAfterDays`.
 */
public class Lifecycle private constructor(builder: Builder) {
    /**
     * The number of days after creation that a recovery point is deleted. This value must be at least 90 days after the number of days specified in `MoveToColdStorageAfterDays`.
     */
    public val deleteAfterDays: kotlin.Long? = builder.deleteAfterDays
    /**
     * The number of days after creation that a recovery point is moved to cold storage.
     */
    public val moveToColdStorageAfterDays: kotlin.Long? = builder.moveToColdStorageAfterDays
    /**
     * If the value is true, your backup plan transitions supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
     */
    public val optInToArchiveForSupportedResources: kotlin.Boolean? = builder.optInToArchiveForSupportedResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.Lifecycle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Lifecycle(")
        append("deleteAfterDays=$deleteAfterDays,")
        append("moveToColdStorageAfterDays=$moveToColdStorageAfterDays,")
        append("optInToArchiveForSupportedResources=$optInToArchiveForSupportedResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteAfterDays?.hashCode() ?: 0
        result = 31 * result + (moveToColdStorageAfterDays?.hashCode() ?: 0)
        result = 31 * result + (optInToArchiveForSupportedResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Lifecycle

        if (deleteAfterDays != other.deleteAfterDays) return false
        if (moveToColdStorageAfterDays != other.moveToColdStorageAfterDays) return false
        if (optInToArchiveForSupportedResources != other.optInToArchiveForSupportedResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.Lifecycle = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days after creation that a recovery point is deleted. This value must be at least 90 days after the number of days specified in `MoveToColdStorageAfterDays`.
         */
        public var deleteAfterDays: kotlin.Long? = null
        /**
         * The number of days after creation that a recovery point is moved to cold storage.
         */
        public var moveToColdStorageAfterDays: kotlin.Long? = null
        /**
         * If the value is true, your backup plan transitions supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
         */
        public var optInToArchiveForSupportedResources: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.Lifecycle) : this() {
            this.deleteAfterDays = x.deleteAfterDays
            this.moveToColdStorageAfterDays = x.moveToColdStorageAfterDays
            this.optInToArchiveForSupportedResources = x.optInToArchiveForSupportedResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.Lifecycle = Lifecycle(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
