// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This is a recovery point that has an associated backup index.
 *
 * Only recovery points with a backup index can be included in a search.
 */
public class IndexedRecoveryPoint private constructor(builder: Builder) {
    /**
     * The date and time that a backup was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val backupCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.backupCreationDate
    /**
     * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
     *
     * For example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * This specifies the IAM role ARN used for this operation.
     *
     * For example, arn:aws:iam::123456789012:role/S3Access
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val indexCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.indexCreationDate
    /**
     * This is the current status for the backup index associated with the specified recovery point.
     *
     * Statuses are: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
     *
     * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
     */
    public val indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = builder.indexStatus
    /**
     * A string in the form of a detailed message explaining the status of a backup index associated with the recovery point.
     */
    public val indexStatusMessage: kotlin.String? = builder.indexStatusMessage
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * The resource type of the indexed recovery point.
     * + `EBS` for Amazon Elastic Block Store
     * + `S3` for Amazon Simple Storage Service (Amazon S3)
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
     */
    public val sourceResourceArn: kotlin.String? = builder.sourceResourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.IndexedRecoveryPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndexedRecoveryPoint(")
        append("backupCreationDate=$backupCreationDate,")
        append("backupVaultArn=$backupVaultArn,")
        append("iamRoleArn=$iamRoleArn,")
        append("indexCreationDate=$indexCreationDate,")
        append("indexStatus=$indexStatus,")
        append("indexStatusMessage=$indexStatusMessage,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceType=$resourceType,")
        append("sourceResourceArn=$sourceResourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupCreationDate?.hashCode() ?: 0
        result = 31 * result + (backupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (indexCreationDate?.hashCode() ?: 0)
        result = 31 * result + (indexStatus?.hashCode() ?: 0)
        result = 31 * result + (indexStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceResourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndexedRecoveryPoint

        if (backupCreationDate != other.backupCreationDate) return false
        if (backupVaultArn != other.backupVaultArn) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (indexCreationDate != other.indexCreationDate) return false
        if (indexStatus != other.indexStatus) return false
        if (indexStatusMessage != other.indexStatusMessage) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceType != other.resourceType) return false
        if (sourceResourceArn != other.sourceResourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.IndexedRecoveryPoint = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that a backup was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var backupCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
         *
         * For example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * This specifies the IAM role ARN used for this operation.
         *
         * For example, arn:aws:iam::123456789012:role/S3Access
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var indexCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is the current status for the backup index associated with the specified recovery point.
         *
         * Statuses are: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
         *
         * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
         */
        public var indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = null
        /**
         * A string in the form of a detailed message explaining the status of a backup index associated with the recovery point.
         */
        public var indexStatusMessage: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * The resource type of the indexed recovery point.
         * + `EBS` for Amazon Elastic Block Store
         * + `S3` for Amazon Simple Storage Service (Amazon S3)
         */
        public var resourceType: kotlin.String? = null
        /**
         * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
         */
        public var sourceResourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.IndexedRecoveryPoint) : this() {
            this.backupCreationDate = x.backupCreationDate
            this.backupVaultArn = x.backupVaultArn
            this.iamRoleArn = x.iamRoleArn
            this.indexCreationDate = x.indexCreationDate
            this.indexStatus = x.indexStatus
            this.indexStatusMessage = x.indexStatusMessage
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceType = x.resourceType
            this.sourceResourceArn = x.sourceResourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.IndexedRecoveryPoint = IndexedRecoveryPoint(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
