// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetRecoveryPointIndexDetailsResponse private constructor(builder: Builder) {
    /**
     * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
     *
     * For example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val indexCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.indexCompletionDate
    /**
     * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val indexCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.indexCreationDate
    /**
     * The date and time that a backup index was deleted, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val indexDeletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.indexDeletionDate
    /**
     * This is the current status for the backup index associated with the specified recovery point.
     *
     * Statuses are: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
     *
     * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
     */
    public val indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = builder.indexStatus
    /**
     * A detailed message explaining the status of a backup index associated with the recovery point.
     */
    public val indexStatusMessage: kotlin.String? = builder.indexStatusMessage
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
     */
    public val sourceResourceArn: kotlin.String? = builder.sourceResourceArn
    /**
     * Count of items within the backup index associated with the recovery point.
     */
    public val totalItemsIndexed: kotlin.Long? = builder.totalItemsIndexed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.GetRecoveryPointIndexDetailsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecoveryPointIndexDetailsResponse(")
        append("backupVaultArn=$backupVaultArn,")
        append("indexCompletionDate=$indexCompletionDate,")
        append("indexCreationDate=$indexCreationDate,")
        append("indexDeletionDate=$indexDeletionDate,")
        append("indexStatus=$indexStatus,")
        append("indexStatusMessage=$indexStatusMessage,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("sourceResourceArn=$sourceResourceArn,")
        append("totalItemsIndexed=$totalItemsIndexed")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultArn?.hashCode() ?: 0
        result = 31 * result + (indexCompletionDate?.hashCode() ?: 0)
        result = 31 * result + (indexCreationDate?.hashCode() ?: 0)
        result = 31 * result + (indexDeletionDate?.hashCode() ?: 0)
        result = 31 * result + (indexStatus?.hashCode() ?: 0)
        result = 31 * result + (indexStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (sourceResourceArn?.hashCode() ?: 0)
        result = 31 * result + (totalItemsIndexed?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecoveryPointIndexDetailsResponse

        if (backupVaultArn != other.backupVaultArn) return false
        if (indexCompletionDate != other.indexCompletionDate) return false
        if (indexCreationDate != other.indexCreationDate) return false
        if (indexDeletionDate != other.indexDeletionDate) return false
        if (indexStatus != other.indexStatus) return false
        if (indexStatusMessage != other.indexStatusMessage) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (sourceResourceArn != other.sourceResourceArn) return false
        if (totalItemsIndexed != other.totalItemsIndexed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.GetRecoveryPointIndexDetailsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
         *
         * For example, `arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var indexCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var indexCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that a backup index was deleted, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var indexDeletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is the current status for the backup index associated with the specified recovery point.
         *
         * Statuses are: `PENDING` | `ACTIVE` | `FAILED` | `DELETING`
         *
         * A recovery point with an index that has the status of `ACTIVE` can be included in a search.
         */
        public var indexStatus: aws.sdk.kotlin.services.backup.model.IndexStatus? = null
        /**
         * A detailed message explaining the status of a backup index associated with the recovery point.
         */
        public var indexStatusMessage: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
         */
        public var sourceResourceArn: kotlin.String? = null
        /**
         * Count of items within the backup index associated with the recovery point.
         */
        public var totalItemsIndexed: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.GetRecoveryPointIndexDetailsResponse) : this() {
            this.backupVaultArn = x.backupVaultArn
            this.indexCompletionDate = x.indexCompletionDate
            this.indexCreationDate = x.indexCreationDate
            this.indexDeletionDate = x.indexDeletionDate
            this.indexStatus = x.indexStatus
            this.indexStatusMessage = x.indexStatusMessage
            this.recoveryPointArn = x.recoveryPointArn
            this.sourceResourceArn = x.sourceResourceArn
            this.totalItemsIndexed = x.totalItemsIndexed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.GetRecoveryPointIndexDetailsResponse = GetRecoveryPointIndexDetailsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
