// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies a scheduled task used to back up a selection of resources.
 */
public class BackupRule private constructor(builder: Builder) {
    /**
     * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
     */
    public val completionWindowMinutes: kotlin.Long? = builder.completionWindowMinutes
    /**
     * An array of `CopyAction` objects, which contains the details of the copy operation.
     */
    public val copyActions: List<CopyAction>? = builder.copyActions
    /**
     * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
     */
    public val enableContinuousBackup: kotlin.Boolean? = builder.enableContinuousBackup
    /**
     * IndexActions is an array you use to specify how backup data should be indexed.
     *
     * eEach BackupRule can have 0 or 1 IndexAction, as each backup can have up to one index associated with it.
     *
     * Within the array is ResourceType. Only one will be accepted for each BackupRule.
     */
    public val indexActions: List<IndexAction>? = builder.indexActions
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * The tags that are assigned to resources that are associated with this rule when restored from backup.
     */
    public val recoveryPointTags: Map<String, String>? = builder.recoveryPointTags
    /**
     * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val ruleName: kotlin.String = requireNotNull(builder.ruleName) { "A non-null value must be provided for ruleName" }
    /**
     * A cron expression in UTC specifying when Backup initiates a backup job. For more information about Amazon Web Services cron expressions, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the *Amazon CloudWatch Events User Guide.*. Two examples of Amazon Web Services cron expressions are ` 15 * ? * * *` (take a backup every hour at 15 minutes past the hour) and `0 12 * * ? *` (take a backup every day at 12 noon UTC). For a table of examples, click the preceding link and scroll down the page.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
     */
    public val scheduleExpressionTimezone: kotlin.String? = builder.scheduleExpressionTimezone
    /**
     * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.
     *
     * During the start window, the backup job status remains in `CREATED` status until it has successfully begun or until the start window time has run out. If within the start window time Backup receives an error that allows the job to be retried, Backup will automatically retry to begin the job at least every 10 minutes until the backup successfully begins (the job status changes to `RUNNING`) or until the job status changes to `EXPIRED` (which is expected to occur when the start window time is over).
     */
    public val startWindowMinutes: kotlin.Long? = builder.startWindowMinutes
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created.
     */
    public val targetBackupVaultName: kotlin.String = requireNotNull(builder.targetBackupVaultName) { "A non-null value must be provided for targetBackupVaultName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupRule(")
        append("completionWindowMinutes=$completionWindowMinutes,")
        append("copyActions=$copyActions,")
        append("enableContinuousBackup=$enableContinuousBackup,")
        append("indexActions=$indexActions,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointTags=*** Sensitive Data Redacted ***,")
        append("ruleId=$ruleId,")
        append("ruleName=$ruleName,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleExpressionTimezone=$scheduleExpressionTimezone,")
        append("startWindowMinutes=$startWindowMinutes,")
        append("targetBackupVaultName=$targetBackupVaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionWindowMinutes?.hashCode() ?: 0
        result = 31 * result + (copyActions?.hashCode() ?: 0)
        result = 31 * result + (enableContinuousBackup?.hashCode() ?: 0)
        result = 31 * result + (indexActions?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointTags?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (ruleName.hashCode())
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpressionTimezone?.hashCode() ?: 0)
        result = 31 * result + (startWindowMinutes?.hashCode() ?: 0)
        result = 31 * result + (targetBackupVaultName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupRule

        if (completionWindowMinutes != other.completionWindowMinutes) return false
        if (copyActions != other.copyActions) return false
        if (enableContinuousBackup != other.enableContinuousBackup) return false
        if (indexActions != other.indexActions) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointTags != other.recoveryPointTags) return false
        if (ruleId != other.ruleId) return false
        if (ruleName != other.ruleName) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleExpressionTimezone != other.scheduleExpressionTimezone) return false
        if (startWindowMinutes != other.startWindowMinutes) return false
        if (targetBackupVaultName != other.targetBackupVaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
         */
        public var completionWindowMinutes: kotlin.Long? = null
        /**
         * An array of `CopyAction` objects, which contains the details of the copy operation.
         */
        public var copyActions: List<CopyAction>? = null
        /**
         * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
         */
        public var enableContinuousBackup: kotlin.Boolean? = null
        /**
         * IndexActions is an array you use to specify how backup data should be indexed.
         *
         * eEach BackupRule can have 0 or 1 IndexAction, as each backup can have up to one index associated with it.
         *
         * Within the array is ResourceType. Only one will be accepted for each BackupRule.
         */
        public var indexActions: List<IndexAction>? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that can transition to cold storage are listed in the [Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * The tags that are assigned to resources that are associated with this rule when restored from backup.
         */
        public var recoveryPointTags: Map<String, String>? = null
        /**
         * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
         */
        public var ruleId: kotlin.String? = null
        /**
         * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var ruleName: kotlin.String? = null
        /**
         * A cron expression in UTC specifying when Backup initiates a backup job. For more information about Amazon Web Services cron expressions, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the *Amazon CloudWatch Events User Guide.*. Two examples of Amazon Web Services cron expressions are ` 15 * ? * * *` (take a backup every hour at 15 minutes past the hour) and `0 12 * * ? *` (take a backup every day at 12 noon UTC). For a table of examples, click the preceding link and scroll down the page.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * The timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         */
        public var scheduleExpressionTimezone: kotlin.String? = null
        /**
         * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.
         *
         * During the start window, the backup job status remains in `CREATED` status until it has successfully begun or until the start window time has run out. If within the start window time Backup receives an error that allows the job to be retried, Backup will automatically retry to begin the job at least every 10 minutes until the backup successfully begins (the job status changes to `RUNNING`) or until the job status changes to `EXPIRED` (which is expected to occur when the start window time is over).
         */
        public var startWindowMinutes: kotlin.Long? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created.
         */
        public var targetBackupVaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupRule) : this() {
            this.completionWindowMinutes = x.completionWindowMinutes
            this.copyActions = x.copyActions
            this.enableContinuousBackup = x.enableContinuousBackup
            this.indexActions = x.indexActions
            this.lifecycle = x.lifecycle
            this.recoveryPointTags = x.recoveryPointTags
            this.ruleId = x.ruleId
            this.ruleName = x.ruleName
            this.scheduleExpression = x.scheduleExpression
            this.scheduleExpressionTimezone = x.scheduleExpressionTimezone
            this.startWindowMinutes = x.startWindowMinutes
            this.targetBackupVaultName = x.targetBackupVaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupRule = BackupRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (ruleName == null) ruleName = ""
            if (targetBackupVaultName == null) targetBackupVaultName = ""
            return this
        }
    }
}
