// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This contains metadata about a restore testing selection.
 */
public class RestoreTestingSelectionForList private constructor(builder: Builder) {
    /**
     * This is the date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26,2018 12:11:30.087 AM.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String = requireNotNull(builder.iamRoleArn) { "A non-null value must be provided for iamRoleArn" }
    /**
     * The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS volume or an Amazon RDS database.
     */
    public val protectedResourceType: kotlin.String = requireNotNull(builder.protectedResourceType) { "A non-null value must be provided for protectedResourceType" }
    /**
     * Unique string that is the name of the restore testing plan.
     *
     * The name cannot be changed after creation. The name must consist of only alphanumeric characters and underscores. Maximum length is 50.
     */
    public val restoreTestingPlanName: kotlin.String = requireNotNull(builder.restoreTestingPlanName) { "A non-null value must be provided for restoreTestingPlanName" }
    /**
     * Unique name of a restore testing selection.
     */
    public val restoreTestingSelectionName: kotlin.String = requireNotNull(builder.restoreTestingSelectionName) { "A non-null value must be provided for restoreTestingSelectionName" }
    /**
     * This value represents the time, in hours, data is retained after a restore test so that optional validation can be completed.
     *
     * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
     */
    public val validationWindowHours: kotlin.Int = builder.validationWindowHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingSelectionForList(")
        append("creationTime=$creationTime,")
        append("iamRoleArn=$iamRoleArn,")
        append("protectedResourceType=$protectedResourceType,")
        append("restoreTestingPlanName=$restoreTestingPlanName,")
        append("restoreTestingSelectionName=$restoreTestingSelectionName,")
        append("validationWindowHours=$validationWindowHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (iamRoleArn.hashCode())
        result = 31 * result + (protectedResourceType.hashCode())
        result = 31 * result + (restoreTestingPlanName.hashCode())
        result = 31 * result + (restoreTestingSelectionName.hashCode())
        result = 31 * result + (validationWindowHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingSelectionForList

        if (creationTime != other.creationTime) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (protectedResourceType != other.protectedResourceType) return false
        if (restoreTestingPlanName != other.restoreTestingPlanName) return false
        if (restoreTestingSelectionName != other.restoreTestingSelectionName) return false
        if (validationWindowHours != other.validationWindowHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForList = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This is the date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26,2018 12:11:30.087 AM.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS volume or an Amazon RDS database.
         */
        public var protectedResourceType: kotlin.String? = null
        /**
         * Unique string that is the name of the restore testing plan.
         *
         * The name cannot be changed after creation. The name must consist of only alphanumeric characters and underscores. Maximum length is 50.
         */
        public var restoreTestingPlanName: kotlin.String? = null
        /**
         * Unique name of a restore testing selection.
         */
        public var restoreTestingSelectionName: kotlin.String? = null
        /**
         * This value represents the time, in hours, data is retained after a restore test so that optional validation can be completed.
         *
         * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
         */
        public var validationWindowHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForList) : this() {
            this.creationTime = x.creationTime
            this.iamRoleArn = x.iamRoleArn
            this.protectedResourceType = x.protectedResourceType
            this.restoreTestingPlanName = x.restoreTestingPlanName
            this.restoreTestingSelectionName = x.restoreTestingSelectionName
            this.validationWindowHours = x.validationWindowHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForList = RestoreTestingSelectionForList(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (iamRoleArn == null) iamRoleArn = ""
            if (protectedResourceType == null) protectedResourceType = ""
            if (restoreTestingPlanName == null) restoreTestingPlanName = ""
            if (restoreTestingSelectionName == null) restoreTestingSelectionName = ""
            return this
        }
    }
}
