// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This contains metadata about a restore testing selection.
 */
public class RestoreTestingSelectionForGet private constructor(builder: Builder) {
    /**
     * The date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 201812:11:30.087 AM.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * This identifies the request and allows failed requests to be retried without the risk of running the operation twice. If the request includes a `CreatorRequestId` that matches an existing backup plan, that plan is returned. This parameter is optional.
     *
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:`arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String = requireNotNull(builder.iamRoleArn) { "A non-null value must be provided for iamRoleArn" }
    /**
     * You can include specific ARNs, such as `ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]` or you can include a wildcard: `ProtectedResourceArns: ["*"]`, but not both.
     */
    public val protectedResourceArns: List<String>? = builder.protectedResourceArns
    /**
     * In a resource testing selection, this parameter filters by specific conditions such as `StringEquals` or `StringNotEquals`.
     */
    public val protectedResourceConditions: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions? = builder.protectedResourceConditions
    /**
     * The type of Amazon Web Services resource included in a resource testing selection; for example, an Amazon EBS volume or an Amazon RDS database.
     */
    public val protectedResourceType: kotlin.String = requireNotNull(builder.protectedResourceType) { "A non-null value must be provided for protectedResourceType" }
    /**
     * You can override certain restore metadata keys by including the parameter `RestoreMetadataOverrides` in the body of `RestoreTestingSelection`. Key values are not case sensitive.
     *
     * See the complete list of [restore testing inferred metadata](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
     */
    public val restoreMetadataOverrides: Map<String, String>? = builder.restoreMetadataOverrides
    /**
     * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
     */
    public val restoreTestingPlanName: kotlin.String = requireNotNull(builder.restoreTestingPlanName) { "A non-null value must be provided for restoreTestingPlanName" }
    /**
     * This is the unique name of the restore testing selection that belongs to the related restore testing plan.
     */
    public val restoreTestingSelectionName: kotlin.String = requireNotNull(builder.restoreTestingSelectionName) { "A non-null value must be provided for restoreTestingSelectionName" }
    /**
     * This is amount of hours (1 to 168) available to run a validation script on the data. The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.
     */
    public val validationWindowHours: kotlin.Int = builder.validationWindowHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForGet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingSelectionForGet(")
        append("creationTime=$creationTime,")
        append("creatorRequestId=$creatorRequestId,")
        append("iamRoleArn=$iamRoleArn,")
        append("protectedResourceArns=$protectedResourceArns,")
        append("protectedResourceConditions=$protectedResourceConditions,")
        append("protectedResourceType=$protectedResourceType,")
        append("restoreMetadataOverrides=*** Sensitive Data Redacted ***,")
        append("restoreTestingPlanName=$restoreTestingPlanName,")
        append("restoreTestingSelectionName=$restoreTestingSelectionName,")
        append("validationWindowHours=$validationWindowHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn.hashCode())
        result = 31 * result + (protectedResourceArns?.hashCode() ?: 0)
        result = 31 * result + (protectedResourceConditions?.hashCode() ?: 0)
        result = 31 * result + (protectedResourceType.hashCode())
        result = 31 * result + (restoreMetadataOverrides?.hashCode() ?: 0)
        result = 31 * result + (restoreTestingPlanName.hashCode())
        result = 31 * result + (restoreTestingSelectionName.hashCode())
        result = 31 * result + (validationWindowHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingSelectionForGet

        if (creationTime != other.creationTime) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (protectedResourceArns != other.protectedResourceArns) return false
        if (protectedResourceConditions != other.protectedResourceConditions) return false
        if (protectedResourceType != other.protectedResourceType) return false
        if (restoreMetadataOverrides != other.restoreMetadataOverrides) return false
        if (restoreTestingPlanName != other.restoreTestingPlanName) return false
        if (restoreTestingSelectionName != other.restoreTestingSelectionName) return false
        if (validationWindowHours != other.validationWindowHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForGet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 201812:11:30.087 AM.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This identifies the request and allows failed requests to be retried without the risk of running the operation twice. If the request includes a `CreatorRequestId` that matches an existing backup plan, that plan is returned. This parameter is optional.
         *
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:`arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * You can include specific ARNs, such as `ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]` or you can include a wildcard: `ProtectedResourceArns: ["*"]`, but not both.
         */
        public var protectedResourceArns: List<String>? = null
        /**
         * In a resource testing selection, this parameter filters by specific conditions such as `StringEquals` or `StringNotEquals`.
         */
        public var protectedResourceConditions: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions? = null
        /**
         * The type of Amazon Web Services resource included in a resource testing selection; for example, an Amazon EBS volume or an Amazon RDS database.
         */
        public var protectedResourceType: kotlin.String? = null
        /**
         * You can override certain restore metadata keys by including the parameter `RestoreMetadataOverrides` in the body of `RestoreTestingSelection`. Key values are not case sensitive.
         *
         * See the complete list of [restore testing inferred metadata](https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
         */
        public var restoreMetadataOverrides: Map<String, String>? = null
        /**
         * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
         */
        public var restoreTestingPlanName: kotlin.String? = null
        /**
         * This is the unique name of the restore testing selection that belongs to the related restore testing plan.
         */
        public var restoreTestingSelectionName: kotlin.String? = null
        /**
         * This is amount of hours (1 to 168) available to run a validation script on the data. The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.
         */
        public var validationWindowHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForGet) : this() {
            this.creationTime = x.creationTime
            this.creatorRequestId = x.creatorRequestId
            this.iamRoleArn = x.iamRoleArn
            this.protectedResourceArns = x.protectedResourceArns
            this.protectedResourceConditions = x.protectedResourceConditions
            this.protectedResourceType = x.protectedResourceType
            this.restoreMetadataOverrides = x.restoreMetadataOverrides
            this.restoreTestingPlanName = x.restoreTestingPlanName
            this.restoreTestingSelectionName = x.restoreTestingSelectionName
            this.validationWindowHours = x.validationWindowHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingSelectionForGet = RestoreTestingSelectionForGet(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions] inside the given [block]
         */
        public fun protectedResourceConditions(block: aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions.Builder.() -> kotlin.Unit) {
            this.protectedResourceConditions = aws.sdk.kotlin.services.backup.model.ProtectedResourceConditions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (iamRoleArn == null) iamRoleArn = ""
            if (protectedResourceType == null) protectedResourceType = ""
            if (restoreTestingPlanName == null) restoreTestingPlanName = ""
            if (restoreTestingSelectionName == null) restoreTestingSelectionName = ""
            return this
        }
    }
}
