// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This contains metadata about a restore testing plan.
 */
public class RestoreTestingPlanForList private constructor(builder: Builder) {
    /**
     * The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of `LastExecutionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lastExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastExecutionTime
    /**
     * The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of `LastUpdateTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
     */
    public val restoreTestingPlanArn: kotlin.String = requireNotNull(builder.restoreTestingPlanArn) { "A non-null value must be provided for restoreTestingPlanArn" }
    /**
     * This is the restore testing plan name.
     */
    public val restoreTestingPlanName: kotlin.String = requireNotNull(builder.restoreTestingPlanName) { "A non-null value must be provided for restoreTestingPlanName" }
    /**
     * A CRON expression in specified timezone when a restore testing plan is executed.
     */
    public val scheduleExpression: kotlin.String = requireNotNull(builder.scheduleExpression) { "A non-null value must be provided for scheduleExpression" }
    /**
     * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
     */
    public val scheduleExpressionTimezone: kotlin.String? = builder.scheduleExpressionTimezone
    /**
     * Defaults to 24 hours.
     *
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
     */
    public val startWindowHours: kotlin.Int = builder.startWindowHours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTestingPlanForList(")
        append("creationTime=$creationTime,")
        append("lastExecutionTime=$lastExecutionTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("restoreTestingPlanArn=$restoreTestingPlanArn,")
        append("restoreTestingPlanName=$restoreTestingPlanName,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleExpressionTimezone=$scheduleExpressionTimezone,")
        append("startWindowHours=$startWindowHours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (lastExecutionTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (restoreTestingPlanArn.hashCode())
        result = 31 * result + (restoreTestingPlanName.hashCode())
        result = 31 * result + (scheduleExpression.hashCode())
        result = 31 * result + (scheduleExpressionTimezone?.hashCode() ?: 0)
        result = 31 * result + (startWindowHours)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTestingPlanForList

        if (creationTime != other.creationTime) return false
        if (lastExecutionTime != other.lastExecutionTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (restoreTestingPlanArn != other.restoreTestingPlanArn) return false
        if (restoreTestingPlanName != other.restoreTestingPlanName) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleExpressionTimezone != other.scheduleExpressionTimezone) return false
        if (startWindowHours != other.startWindowHours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForList = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of `LastExecutionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lastExecutionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of `LastUpdateTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
         */
        public var restoreTestingPlanArn: kotlin.String? = null
        /**
         * This is the restore testing plan name.
         */
        public var restoreTestingPlanName: kotlin.String? = null
        /**
         * A CRON expression in specified timezone when a restore testing plan is executed.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         */
        public var scheduleExpressionTimezone: kotlin.String? = null
        /**
         * Defaults to 24 hours.
         *
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
         */
        public var startWindowHours: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForList) : this() {
            this.creationTime = x.creationTime
            this.lastExecutionTime = x.lastExecutionTime
            this.lastUpdateTime = x.lastUpdateTime
            this.restoreTestingPlanArn = x.restoreTestingPlanArn
            this.restoreTestingPlanName = x.restoreTestingPlanName
            this.scheduleExpression = x.scheduleExpression
            this.scheduleExpressionTimezone = x.scheduleExpressionTimezone
            this.startWindowHours = x.startWindowHours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreTestingPlanForList = RestoreTestingPlanForList(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (restoreTestingPlanArn == null) restoreTestingPlanArn = ""
            if (restoreTestingPlanName == null) restoreTestingPlanName = ""
            if (scheduleExpression == null) scheduleExpression = ""
            return this
        }
    }
}
