// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains information about a backed-up resource.
 */
public class ProtectedResource private constructor(builder: Builder) {
    /**
     * The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of `LastBackupTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lastBackupTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastBackupTime
    /**
     * This is the ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
     */
    public val lastBackupVaultArn: kotlin.String? = builder.lastBackupVaultArn
    /**
     * This is the ARN (Amazon Resource Name) of the most recent recovery point.
     */
    public val lastRecoveryPointArn: kotlin.String? = builder.lastRecoveryPointArn
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * This is the non-unique name of the resource that belongs to the specified backup.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ProtectedResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProtectedResource(")
        append("lastBackupTime=$lastBackupTime,")
        append("lastBackupVaultArn=$lastBackupVaultArn,")
        append("lastRecoveryPointArn=$lastRecoveryPointArn,")
        append("resourceArn=$resourceArn,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastBackupTime?.hashCode() ?: 0
        result = 31 * result + (lastBackupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (lastRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProtectedResource

        if (lastBackupTime != other.lastBackupTime) return false
        if (lastBackupVaultArn != other.lastBackupVaultArn) return false
        if (lastRecoveryPointArn != other.lastRecoveryPointArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ProtectedResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of `LastBackupTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lastBackupTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is the ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
         */
        public var lastBackupVaultArn: kotlin.String? = null
        /**
         * This is the ARN (Amazon Resource Name) of the most recent recovery point.
         */
        public var lastRecoveryPointArn: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * This is the non-unique name of the resource that belongs to the specified backup.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ProtectedResource) : this() {
            this.lastBackupTime = x.lastBackupTime
            this.lastBackupVaultArn = x.lastBackupVaultArn
            this.lastRecoveryPointArn = x.lastRecoveryPointArn
            this.resourceArn = x.resourceArn
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ProtectedResource = ProtectedResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
