// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListBackupJobsRequest private constructor(builder: Builder) {
    /**
     * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
     *
     * If used from an Organizations management account, passing `*` returns all jobs across the organization.
     */
    public val byAccountId: kotlin.String? = builder.byAccountId
    /**
     * Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val byBackupVaultName: kotlin.String? = builder.byBackupVaultName
    /**
     * Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
     */
    public val byCompleteAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.byCompleteAfter
    /**
     * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
     */
    public val byCompleteBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.byCompleteBefore
    /**
     * Returns only backup jobs that were created after the specified date.
     */
    public val byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedAfter
    /**
     * Returns only backup jobs that were created before the specified date.
     */
    public val byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedBefore
    /**
     * This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches the value you input.
     *
     * Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`, and `InvalidParameters`.
     *
     * View [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
     *
     * The wildcard () returns count of all message categories.
     *
     * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
     */
    public val byMessageCategory: kotlin.String? = builder.byMessageCategory
    /**
     * This is a filter to list child (nested) jobs based on parent job ID.
     */
    public val byParentJobId: kotlin.String? = builder.byParentJobId
    /**
     * Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
     */
    public val byResourceArn: kotlin.String? = builder.byResourceArn
    /**
     * Returns only backup jobs for the specified resources:
     * + `Aurora` for Amazon Aurora
     * + `CloudFormation` for CloudFormation
     * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
     * + `DynamoDB` for Amazon DynamoDB
     * + `EBS` for Amazon Elastic Block Store
     * + `EC2` for Amazon Elastic Compute Cloud
     * + `EFS` for Amazon Elastic File System
     * + `FSx` for Amazon FSx
     * + `Neptune` for Amazon Neptune
     * + `Redshift` for Amazon Redshift
     * + `RDS` for Amazon Relational Database Service
     * + `SAP HANA on Amazon EC2` for SAP HANA databases
     * + `Storage Gateway` for Storage Gateway
     * + `S3` for Amazon S3
     * + `Timestream` for Amazon Timestream
     * + `VirtualMachine` for virtual machines
     */
    public val byResourceType: kotlin.String? = builder.byResourceType
    /**
     * Returns only backup jobs that are in the specified state.
     *
     * `Completed with issues` is a status found only in the Backup console. For API, this status refers to jobs with a state of `COMPLETED` and a `MessageCategory` with a value other than `SUCCESS`; that is, the status is completed but comes with a status message.
     *
     * To obtain the job count for `Completed with issues`, run two GET requests, and subtract the second, smaller number:
     *
     * GET /backup-jobs/?state=COMPLETED
     *
     * GET /backup-jobs/?messageCategory=SUCCESS&state=COMPLETED
     */
    public val byState: aws.sdk.kotlin.services.backup.model.BackupJobState? = builder.byState
    /**
     * The maximum number of items to be returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The next item following a partial list of returned items. For example, if a request is made to return `MaxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBackupJobsRequest(")
        append("byAccountId=$byAccountId,")
        append("byBackupVaultName=$byBackupVaultName,")
        append("byCompleteAfter=$byCompleteAfter,")
        append("byCompleteBefore=$byCompleteBefore,")
        append("byCreatedAfter=$byCreatedAfter,")
        append("byCreatedBefore=$byCreatedBefore,")
        append("byMessageCategory=$byMessageCategory,")
        append("byParentJobId=$byParentJobId,")
        append("byResourceArn=$byResourceArn,")
        append("byResourceType=$byResourceType,")
        append("byState=$byState,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = byAccountId?.hashCode() ?: 0
        result = 31 * result + (byBackupVaultName?.hashCode() ?: 0)
        result = 31 * result + (byCompleteAfter?.hashCode() ?: 0)
        result = 31 * result + (byCompleteBefore?.hashCode() ?: 0)
        result = 31 * result + (byCreatedAfter?.hashCode() ?: 0)
        result = 31 * result + (byCreatedBefore?.hashCode() ?: 0)
        result = 31 * result + (byMessageCategory?.hashCode() ?: 0)
        result = 31 * result + (byParentJobId?.hashCode() ?: 0)
        result = 31 * result + (byResourceArn?.hashCode() ?: 0)
        result = 31 * result + (byResourceType?.hashCode() ?: 0)
        result = 31 * result + (byState?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBackupJobsRequest

        if (byAccountId != other.byAccountId) return false
        if (byBackupVaultName != other.byBackupVaultName) return false
        if (byCompleteAfter != other.byCompleteAfter) return false
        if (byCompleteBefore != other.byCompleteBefore) return false
        if (byCreatedAfter != other.byCreatedAfter) return false
        if (byCreatedBefore != other.byCreatedBefore) return false
        if (byMessageCategory != other.byMessageCategory) return false
        if (byParentJobId != other.byParentJobId) return false
        if (byResourceArn != other.byResourceArn) return false
        if (byResourceType != other.byResourceType) return false
        if (byState != other.byState) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
         *
         * If used from an Organizations management account, passing `*` returns all jobs across the organization.
         */
        public var byAccountId: kotlin.String? = null
        /**
         * Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var byBackupVaultName: kotlin.String? = null
        /**
         * Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
         */
        public var byCompleteAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
         */
        public var byCompleteBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only backup jobs that were created after the specified date.
         */
        public var byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only backup jobs that were created before the specified date.
         */
        public var byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches the value you input.
         *
         * Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`, and `InvalidParameters`.
         *
         * View [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
         *
         * The wildcard () returns count of all message categories.
         *
         * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
         */
        public var byMessageCategory: kotlin.String? = null
        /**
         * This is a filter to list child (nested) jobs based on parent job ID.
         */
        public var byParentJobId: kotlin.String? = null
        /**
         * Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
         */
        public var byResourceArn: kotlin.String? = null
        /**
         * Returns only backup jobs for the specified resources:
         * + `Aurora` for Amazon Aurora
         * + `CloudFormation` for CloudFormation
         * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
         * + `DynamoDB` for Amazon DynamoDB
         * + `EBS` for Amazon Elastic Block Store
         * + `EC2` for Amazon Elastic Compute Cloud
         * + `EFS` for Amazon Elastic File System
         * + `FSx` for Amazon FSx
         * + `Neptune` for Amazon Neptune
         * + `Redshift` for Amazon Redshift
         * + `RDS` for Amazon Relational Database Service
         * + `SAP HANA on Amazon EC2` for SAP HANA databases
         * + `Storage Gateway` for Storage Gateway
         * + `S3` for Amazon S3
         * + `Timestream` for Amazon Timestream
         * + `VirtualMachine` for virtual machines
         */
        public var byResourceType: kotlin.String? = null
        /**
         * Returns only backup jobs that are in the specified state.
         *
         * `Completed with issues` is a status found only in the Backup console. For API, this status refers to jobs with a state of `COMPLETED` and a `MessageCategory` with a value other than `SUCCESS`; that is, the status is completed but comes with a status message.
         *
         * To obtain the job count for `Completed with issues`, run two GET requests, and subtract the second, smaller number:
         *
         * GET /backup-jobs/?state=COMPLETED
         *
         * GET /backup-jobs/?messageCategory=SUCCESS&state=COMPLETED
         */
        public var byState: aws.sdk.kotlin.services.backup.model.BackupJobState? = null
        /**
         * The maximum number of items to be returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The next item following a partial list of returned items. For example, if a request is made to return `MaxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest) : this() {
            this.byAccountId = x.byAccountId
            this.byBackupVaultName = x.byBackupVaultName
            this.byCompleteAfter = x.byCompleteAfter
            this.byCompleteBefore = x.byCompleteBefore
            this.byCreatedAfter = x.byCreatedAfter
            this.byCreatedBefore = x.byCreatedBefore
            this.byMessageCategory = x.byMessageCategory
            this.byParentJobId = x.byParentJobId
            this.byResourceArn = x.byResourceArn
            this.byResourceType = x.byResourceType
            this.byState = x.byState
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest = ListBackupJobsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
