// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains an array of `Transition` objects specifying how long in days before a recovery point transitions to cold storage or is deleted.
 *
 * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
 *
 * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
 */
public class Lifecycle private constructor(builder: Builder) {
    /**
     * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus `MoveToColdStorageAfterDays`.
     */
    public val deleteAfterDays: kotlin.Long? = builder.deleteAfterDays
    /**
     * Specifies the number of days after creation that a recovery point is moved to cold storage.
     */
    public val moveToColdStorageAfterDays: kotlin.Long? = builder.moveToColdStorageAfterDays
    /**
     * Optional Boolean. If this is true, this setting will instruct your backup plan to transition supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
     */
    public val optInToArchiveForSupportedResources: kotlin.Boolean? = builder.optInToArchiveForSupportedResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.Lifecycle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Lifecycle(")
        append("deleteAfterDays=$deleteAfterDays,")
        append("moveToColdStorageAfterDays=$moveToColdStorageAfterDays,")
        append("optInToArchiveForSupportedResources=$optInToArchiveForSupportedResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteAfterDays?.hashCode() ?: 0
        result = 31 * result + (moveToColdStorageAfterDays?.hashCode() ?: 0)
        result = 31 * result + (optInToArchiveForSupportedResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Lifecycle

        if (deleteAfterDays != other.deleteAfterDays) return false
        if (moveToColdStorageAfterDays != other.moveToColdStorageAfterDays) return false
        if (optInToArchiveForSupportedResources != other.optInToArchiveForSupportedResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.Lifecycle = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus `MoveToColdStorageAfterDays`.
         */
        public var deleteAfterDays: kotlin.Long? = null
        /**
         * Specifies the number of days after creation that a recovery point is moved to cold storage.
         */
        public var moveToColdStorageAfterDays: kotlin.Long? = null
        /**
         * Optional Boolean. If this is true, this setting will instruct your backup plan to transition supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
         */
        public var optInToArchiveForSupportedResources: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.Lifecycle) : this() {
            this.deleteAfterDays = x.deleteAfterDays
            this.moveToColdStorageAfterDays = x.moveToColdStorageAfterDays
            this.optInToArchiveForSupportedResources = x.optInToArchiveForSupportedResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.Lifecycle = Lifecycle(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
