// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeBackupVaultResponse private constructor(builder: Builder) {
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     */
    public val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn
    /**
     * The date and time when Backup Vault Lock configuration cannot be changed or deleted.
     *
     * If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.
     *
     * This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lockDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lockDate
    /**
     * A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. `True` means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.
     */
    public val locked: kotlin.Boolean? = builder.locked
    /**
     * The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).
     *
     * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.
     */
    public val maxRetentionDays: kotlin.Long? = builder.maxRetentionDays
    /**
     * The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.
     *
     * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.
     */
    public val minRetentionDays: kotlin.Long? = builder.minRetentionDays
    /**
     * The number of recovery points that are stored in a backup vault.
     */
    public val numberOfRecoveryPoints: kotlin.Long = builder.numberOfRecoveryPoints
    /**
     * This is the type of vault described.
     */
    public val vaultType: aws.sdk.kotlin.services.backup.model.VaultType? = builder.vaultType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBackupVaultResponse(")
        append("backupVaultArn=$backupVaultArn,")
        append("backupVaultName=$backupVaultName,")
        append("creationDate=$creationDate,")
        append("creatorRequestId=$creatorRequestId,")
        append("encryptionKeyArn=$encryptionKeyArn,")
        append("lockDate=$lockDate,")
        append("locked=$locked,")
        append("maxRetentionDays=$maxRetentionDays,")
        append("minRetentionDays=$minRetentionDays,")
        append("numberOfRecoveryPoints=$numberOfRecoveryPoints,")
        append("vaultType=$vaultType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultArn?.hashCode() ?: 0
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lockDate?.hashCode() ?: 0)
        result = 31 * result + (locked?.hashCode() ?: 0)
        result = 31 * result + (maxRetentionDays?.hashCode() ?: 0)
        result = 31 * result + (minRetentionDays?.hashCode() ?: 0)
        result = 31 * result + (numberOfRecoveryPoints.hashCode())
        result = 31 * result + (vaultType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeBackupVaultResponse

        if (backupVaultArn != other.backupVaultArn) return false
        if (backupVaultName != other.backupVaultName) return false
        if (creationDate != other.creationDate) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false
        if (lockDate != other.lockDate) return false
        if (locked != other.locked) return false
        if (maxRetentionDays != other.maxRetentionDays) return false
        if (minRetentionDays != other.minRetentionDays) return false
        if (numberOfRecoveryPoints != other.numberOfRecoveryPoints) return false
        if (vaultType != other.vaultType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         */
        public var encryptionKeyArn: kotlin.String? = null
        /**
         * The date and time when Backup Vault Lock configuration cannot be changed or deleted.
         *
         * If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.
         *
         * This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lockDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. `True` means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.
         */
        public var locked: kotlin.Boolean? = null
        /**
         * The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).
         *
         * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.
         */
        public var maxRetentionDays: kotlin.Long? = null
        /**
         * The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.
         *
         * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.
         */
        public var minRetentionDays: kotlin.Long? = null
        /**
         * The number of recovery points that are stored in a backup vault.
         */
        public var numberOfRecoveryPoints: kotlin.Long = 0L
        /**
         * This is the type of vault described.
         */
        public var vaultType: aws.sdk.kotlin.services.backup.model.VaultType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse) : this() {
            this.backupVaultArn = x.backupVaultArn
            this.backupVaultName = x.backupVaultName
            this.creationDate = x.creationDate
            this.creatorRequestId = x.creatorRequestId
            this.encryptionKeyArn = x.encryptionKeyArn
            this.lockDate = x.lockDate
            this.locked = x.locked
            this.maxRetentionDays = x.maxRetentionDays
            this.minRetentionDays = x.minRetentionDays
            this.numberOfRecoveryPoints = x.numberOfRecoveryPoints
            this.vaultType = x.vaultType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse = DescribeBackupVaultResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
