// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This is a summary of copy jobs created or running within the most recent 30 days.
 *
 * The returned summary may contain the following: Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
 */
public class CopyJobSummary private constructor(builder: Builder) {
    /**
     * The account ID that owns the jobs within the summary.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The value as a number of jobs in a job summary.
     */
    public val count: kotlin.Int = builder.count
    /**
     * The value of time in number format of a job end time.
     *
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * This parameter is the job count for the specified message category.
     *
     * Example strings include `AccessDenied`, `Success`, and `InvalidParameters`. See [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of MessageCategory strings.
     *
     * The the value ANY returns count of all message categories.
     *
     * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
     */
    public val messageCategory: kotlin.String? = builder.messageCategory
    /**
     * This is the Amazon Web Services Regions within the job summary.
     */
    public val region: kotlin.String? = builder.region
    /**
     * This value is the job count for the specified resource type. The request `GetSupportedResourceTypes` returns strings for supported resource types
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The value of time in number format of a job start time.
     *
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * This value is job count for jobs with the specified state.
     */
    public val state: aws.sdk.kotlin.services.backup.model.CopyJobStatus? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.CopyJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyJobSummary(")
        append("accountId=$accountId,")
        append("count=$count,")
        append("endTime=$endTime,")
        append("messageCategory=$messageCategory,")
        append("region=$region,")
        append("resourceType=$resourceType,")
        append("startTime=$startTime,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (count)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (messageCategory?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyJobSummary

        if (accountId != other.accountId) return false
        if (count != other.count) return false
        if (endTime != other.endTime) return false
        if (messageCategory != other.messageCategory) return false
        if (region != other.region) return false
        if (resourceType != other.resourceType) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.CopyJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The account ID that owns the jobs within the summary.
         */
        public var accountId: kotlin.String? = null
        /**
         * The value as a number of jobs in a job summary.
         */
        public var count: kotlin.Int = 0
        /**
         * The value of time in number format of a job end time.
         *
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This parameter is the job count for the specified message category.
         *
         * Example strings include `AccessDenied`, `Success`, and `InvalidParameters`. See [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of MessageCategory strings.
         *
         * The the value ANY returns count of all message categories.
         *
         * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
         */
        public var messageCategory: kotlin.String? = null
        /**
         * This is the Amazon Web Services Regions within the job summary.
         */
        public var region: kotlin.String? = null
        /**
         * This value is the job count for the specified resource type. The request `GetSupportedResourceTypes` returns strings for supported resource types
         */
        public var resourceType: kotlin.String? = null
        /**
         * The value of time in number format of a job start time.
         *
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This value is job count for jobs with the specified state.
         */
        public var state: aws.sdk.kotlin.services.backup.model.CopyJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.CopyJobSummary) : this() {
            this.accountId = x.accountId
            this.count = x.count
            this.endTime = x.endTime
            this.messageCategory = x.messageCategory
            this.region = x.region
            this.resourceType = x.resourceType
            this.startTime = x.startTime
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.CopyJobSummary = CopyJobSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
