// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of the copy operation.
 */
public class CopyAction private constructor(builder: Builder) {
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val destinationBackupVaultArn: kotlin.String = requireNotNull(builder.destinationBackupVaultArn) { "A non-null value must be provided for destinationBackupVaultArn" }
    /**
     * Contains an array of `Transition` objects specifying how long in days before a recovery point transitions to cold storage or is deleted.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.CopyAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyAction(")
        append("destinationBackupVaultArn=$destinationBackupVaultArn,")
        append("lifecycle=$lifecycle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationBackupVaultArn.hashCode()
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyAction

        if (destinationBackupVaultArn != other.destinationBackupVaultArn) return false
        if (lifecycle != other.lifecycle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.CopyAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var destinationBackupVaultArn: kotlin.String? = null
        /**
         * Contains an array of `Transition` objects specifying how long in days before a recovery point transitions to cold storage or is deleted.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.CopyAction) : this() {
            this.destinationBackupVaultArn = x.destinationBackupVaultArn
            this.lifecycle = x.lifecycle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.CopyAction = CopyAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (destinationBackupVaultArn == null) destinationBackupVaultArn = ""
            return this
        }
    }
}
