// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A framework consists of one or more controls. Each control has its own control scope. The control scope can include one or more resource types, a combination of a tag key and value, or a combination of one resource type and one resource ID. If no scope is specified, evaluations for the rule are triggered when any resource in your recording group changes in configuration.
 *
 * To set a control scope that includes all of a particular resource, leave the `ControlScope` empty or do not pass it when calling `CreateFramework`.
 */
public class ControlScope private constructor(builder: Builder) {
    /**
     * The ID of the only Amazon Web Services resource that you want your control scope to contain.
     */
    public val complianceResourceIds: List<String>? = builder.complianceResourceIds
    /**
     * Describes whether the control scope includes one or more types of resources, such as `EFS` or `RDS`.
     */
    public val complianceResourceTypes: List<String>? = builder.complianceResourceTypes
    /**
     * The tag key-value pair applied to those Amazon Web Services resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided. The tag value is optional, but it cannot be an empty string. The structure to assign a tag is: `[{"Key":"string","Value":"string"}]`.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ControlScope = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlScope(")
        append("complianceResourceIds=$complianceResourceIds,")
        append("complianceResourceTypes=$complianceResourceTypes,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = complianceResourceIds?.hashCode() ?: 0
        result = 31 * result + (complianceResourceTypes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlScope

        if (complianceResourceIds != other.complianceResourceIds) return false
        if (complianceResourceTypes != other.complianceResourceTypes) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ControlScope = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the only Amazon Web Services resource that you want your control scope to contain.
         */
        public var complianceResourceIds: List<String>? = null
        /**
         * Describes whether the control scope includes one or more types of resources, such as `EFS` or `RDS`.
         */
        public var complianceResourceTypes: List<String>? = null
        /**
         * The tag key-value pair applied to those Amazon Web Services resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided. The tag value is optional, but it cannot be an empty string. The structure to assign a tag is: `[{"Key":"string","Value":"string"}]`.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ControlScope) : this() {
            this.complianceResourceIds = x.complianceResourceIds
            this.complianceResourceTypes = x.complianceResourceTypes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ControlScope = ControlScope(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
