// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about a backup job.
 */
public class BackupJob private constructor(builder: Builder) {
    /**
     * The account ID that owns the backup job.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * Uniquely identifies a request to Backup to back up a resource.
     */
    public val backupJobId: kotlin.String? = builder.backupJobId
    /**
     * Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
     *
     * Valid values: Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup. Set to `"WindowsVSS":"disabled"` to create a regular backup. If you specify an invalid option, you get an `InvalidParameterValueException` exception.
     */
    public val backupOptions: Map<String, String>? = builder.backupOptions
    /**
     * The size, in bytes, of a backup.
     */
    public val backupSizeInBytes: kotlin.Long? = builder.backupSizeInBytes
    /**
     * Represents the type of backup for a backup job.
     */
    public val backupType: kotlin.String? = builder.backupType
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The size in bytes transferred to a backup vault at the time that the job status was queried.
     */
    public val bytesTransferred: kotlin.Long? = builder.bytesTransferred
    /**
     * The date and time a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * Contains identifying information about the creation of a backup job, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan used to create it.
     */
    public val createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = builder.createdBy
    /**
     * The date and time a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The date and time a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of `ExpectedCompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val expectedCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expectedCompletionDate
    /**
     * Specifies the IAM role ARN used to create the target recovery point. IAM roles other than the default role must include either `AWSBackup` or `AwsBackup` in the role name. For example, `arn:aws:iam::123456789012:role/AWSBackupRDSAccess`. Role names without those strings lack permissions to perform backup jobs.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * This is the date on which the backup job was initiated.
     */
    public val initiationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.initiationDate
    /**
     * This is a boolean value indicating this is a parent (composite) backup job.
     */
    public val isParent: kotlin.Boolean = builder.isParent
    /**
     * This parameter is the job count for the specified message category.
     *
     * Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`, and `INVALIDPARAMETERS`. See [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of MessageCategory strings.
     *
     * The the value ANY returns count of all message categories.
     *
     * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
     */
    public val messageCategory: kotlin.String? = builder.messageCategory
    /**
     * This uniquely identifies a request to Backup to back up a resource. The return will be the parent (composite) job ID.
     */
    public val parentJobId: kotlin.String? = builder.parentJobId
    /**
     * Contains an estimated percentage complete of a job at the time the job status was queried.
     */
    public val percentDone: kotlin.String? = builder.percentDone
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * This is the non-unique name of the resource that belongs to the specified backup.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the `StartBy` time would be 8:00 PM on the date specified. The value of `StartBy` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val startBy: aws.smithy.kotlin.runtime.time.Instant? = builder.startBy
    /**
     * The current state of a backup job.
     */
    public val state: aws.sdk.kotlin.services.backup.model.BackupJobState? = builder.state
    /**
     * A detailed message explaining the status of the job to back up a resource.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupJob(")
        append("accountId=$accountId,")
        append("backupJobId=$backupJobId,")
        append("backupOptions=$backupOptions,")
        append("backupSizeInBytes=$backupSizeInBytes,")
        append("backupType=$backupType,")
        append("backupVaultArn=$backupVaultArn,")
        append("backupVaultName=$backupVaultName,")
        append("bytesTransferred=$bytesTransferred,")
        append("completionDate=$completionDate,")
        append("createdBy=$createdBy,")
        append("creationDate=$creationDate,")
        append("expectedCompletionDate=$expectedCompletionDate,")
        append("iamRoleArn=$iamRoleArn,")
        append("initiationDate=$initiationDate,")
        append("isParent=$isParent,")
        append("messageCategory=$messageCategory,")
        append("parentJobId=$parentJobId,")
        append("percentDone=$percentDone,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceArn=$resourceArn,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("startBy=$startBy,")
        append("state=$state,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (backupJobId?.hashCode() ?: 0)
        result = 31 * result + (backupOptions?.hashCode() ?: 0)
        result = 31 * result + (backupSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (backupType?.hashCode() ?: 0)
        result = 31 * result + (backupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (bytesTransferred?.hashCode() ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (expectedCompletionDate?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (initiationDate?.hashCode() ?: 0)
        result = 31 * result + (isParent.hashCode())
        result = 31 * result + (messageCategory?.hashCode() ?: 0)
        result = 31 * result + (parentJobId?.hashCode() ?: 0)
        result = 31 * result + (percentDone?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (startBy?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupJob

        if (accountId != other.accountId) return false
        if (backupJobId != other.backupJobId) return false
        if (backupOptions != other.backupOptions) return false
        if (backupSizeInBytes != other.backupSizeInBytes) return false
        if (backupType != other.backupType) return false
        if (backupVaultArn != other.backupVaultArn) return false
        if (backupVaultName != other.backupVaultName) return false
        if (bytesTransferred != other.bytesTransferred) return false
        if (completionDate != other.completionDate) return false
        if (createdBy != other.createdBy) return false
        if (creationDate != other.creationDate) return false
        if (expectedCompletionDate != other.expectedCompletionDate) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (initiationDate != other.initiationDate) return false
        if (isParent != other.isParent) return false
        if (messageCategory != other.messageCategory) return false
        if (parentJobId != other.parentJobId) return false
        if (percentDone != other.percentDone) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (startBy != other.startBy) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupJob = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The account ID that owns the backup job.
         */
        public var accountId: kotlin.String? = null
        /**
         * Uniquely identifies a request to Backup to back up a resource.
         */
        public var backupJobId: kotlin.String? = null
        /**
         * Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
         *
         * Valid values: Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup. Set to `"WindowsVSS":"disabled"` to create a regular backup. If you specify an invalid option, you get an `InvalidParameterValueException` exception.
         */
        public var backupOptions: Map<String, String>? = null
        /**
         * The size, in bytes, of a backup.
         */
        public var backupSizeInBytes: kotlin.Long? = null
        /**
         * Represents the type of backup for a backup job.
         */
        public var backupType: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The size in bytes transferred to a backup vault at the time that the job status was queried.
         */
        public var bytesTransferred: kotlin.Long? = null
        /**
         * The date and time a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains identifying information about the creation of a backup job, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan used to create it.
         */
        public var createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = null
        /**
         * The date and time a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of `ExpectedCompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var expectedCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the IAM role ARN used to create the target recovery point. IAM roles other than the default role must include either `AWSBackup` or `AwsBackup` in the role name. For example, `arn:aws:iam::123456789012:role/AWSBackupRDSAccess`. Role names without those strings lack permissions to perform backup jobs.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * This is the date on which the backup job was initiated.
         */
        public var initiationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is a boolean value indicating this is a parent (composite) backup job.
         */
        public var isParent: kotlin.Boolean = false
        /**
         * This parameter is the job count for the specified message category.
         *
         * Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`, and `INVALIDPARAMETERS`. See [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of MessageCategory strings.
         *
         * The the value ANY returns count of all message categories.
         *
         * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
         */
        public var messageCategory: kotlin.String? = null
        /**
         * This uniquely identifies a request to Backup to back up a resource. The return will be the parent (composite) job ID.
         */
        public var parentJobId: kotlin.String? = null
        /**
         * Contains an estimated percentage complete of a job at the time the job status was queried.
         */
        public var percentDone: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * This is the non-unique name of the resource that belongs to the specified backup.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
         */
        public var resourceType: kotlin.String? = null
        /**
         * Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the `StartBy` time would be 8:00 PM on the date specified. The value of `StartBy` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var startBy: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of a backup job.
         */
        public var state: aws.sdk.kotlin.services.backup.model.BackupJobState? = null
        /**
         * A detailed message explaining the status of the job to back up a resource.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupJob) : this() {
            this.accountId = x.accountId
            this.backupJobId = x.backupJobId
            this.backupOptions = x.backupOptions
            this.backupSizeInBytes = x.backupSizeInBytes
            this.backupType = x.backupType
            this.backupVaultArn = x.backupVaultArn
            this.backupVaultName = x.backupVaultName
            this.bytesTransferred = x.bytesTransferred
            this.completionDate = x.completionDate
            this.createdBy = x.createdBy
            this.creationDate = x.creationDate
            this.expectedCompletionDate = x.expectedCompletionDate
            this.iamRoleArn = x.iamRoleArn
            this.initiationDate = x.initiationDate
            this.isParent = x.isParent
            this.messageCategory = x.messageCategory
            this.parentJobId = x.parentJobId
            this.percentDone = x.percentDone
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceArn = x.resourceArn
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.startBy = x.startBy
            this.state = x.state
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupJob = BackupJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RecoveryPointCreator] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
