// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.Lifecycle
import aws.sdk.kotlin.services.backup.model.StartBackupJobRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartBackupJobOperationSerializer: HttpSerializer.NonStreaming<StartBackupJobRequest> {
    override fun serialize(context: ExecutionContext, input: StartBackupJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encoded = "/backup-jobs"
        }

        val payload = serializeStartBackupJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartBackupJobOperationBody(context: ExecutionContext, input: StartBackupJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKUPOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("BackupOptions"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val COMPLETEWINDOWMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("CompleteWindowMinutes"))
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamRoleArn"))
    val IDEMPOTENCYTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdempotencyToken"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Lifecycle"))
    val RECOVERYPOINTTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("RecoveryPointTags"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val STARTWINDOWMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("StartWindowMinutes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPOPTIONS_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(COMPLETEWINDOWMINUTES_DESCRIPTOR)
        field(IAMROLEARN_DESCRIPTOR)
        field(IDEMPOTENCYTOKEN_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
        field(RECOVERYPOINTTAGS_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(STARTWINDOWMINUTES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.backupOptions != null) {
            mapField(BACKUPOPTIONS_DESCRIPTOR) {
                input.backupOptions.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.backupVaultName?.let { field(BACKUPVAULTNAME_DESCRIPTOR, it) }
        input.completeWindowMinutes?.let { field(COMPLETEWINDOWMINUTES_DESCRIPTOR, it) }
        input.iamRoleArn?.let { field(IAMROLEARN_DESCRIPTOR, it) }
        input.idempotencyToken?.let { field(IDEMPOTENCYTOKEN_DESCRIPTOR, it) }
        input.lifecycle?.let { field(LIFECYCLE_DESCRIPTOR, it, ::serializeLifecycleDocument) }
        if (input.recoveryPointTags != null) {
            mapField(RECOVERYPOINTTAGS_DESCRIPTOR) {
                input.recoveryPointTags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.resourceArn?.let { field(RESOURCEARN_DESCRIPTOR, it) }
        input.startWindowMinutes?.let { field(STARTWINDOWMINUTES_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
