// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.AdvancedBackupSetting
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.BackupPlan
import aws.sdk.kotlin.services.backup.model.GetBackupPlanResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetBackupPlanOperationDeserializer: HttpDeserializer.NonStreaming<GetBackupPlanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBackupPlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBackupPlanError(context, call, payload)
        }
        val builder = GetBackupPlanResponse.Builder()

        if (payload != null) {
            deserializeGetBackupPlanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBackupPlanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBackupPlanOperationBody(builder: GetBackupPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADVANCEDBACKUPSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdvancedBackupSettings"))
    val BACKUPPLAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BackupPlan"))
    val BACKUPPLANARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupPlanArn"))
    val BACKUPPLANID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupPlanId"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val DELETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DeletionDate"))
    val LASTEXECUTIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastExecutionDate"))
    val VERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADVANCEDBACKUPSETTINGS_DESCRIPTOR)
        field(BACKUPPLAN_DESCRIPTOR)
        field(BACKUPPLANARN_DESCRIPTOR)
        field(BACKUPPLANID_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
        field(DELETIONDATE_DESCRIPTOR)
        field(LASTEXECUTIONDATE_DESCRIPTOR)
        field(VERSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADVANCEDBACKUPSETTINGS_DESCRIPTOR.index -> builder.advancedBackupSettings =
                    deserializer.deserializeList(ADVANCEDBACKUPSETTINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdvancedBackupSetting>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdvancedBackupSettingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BACKUPPLAN_DESCRIPTOR.index -> builder.backupPlan = deserializeBackupPlanDocument(deserializer)
                BACKUPPLANARN_DESCRIPTOR.index -> builder.backupPlanArn = deserializeString()
                BACKUPPLANID_DESCRIPTOR.index -> builder.backupPlanId = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATORREQUESTID_DESCRIPTOR.index -> builder.creatorRequestId = deserializeString()
                DELETIONDATE_DESCRIPTOR.index -> builder.deletionDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTEXECUTIONDATE_DESCRIPTOR.index -> builder.lastExecutionDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                VERSIONID_DESCRIPTOR.index -> builder.versionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
