// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.CreateBackupVaultRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateBackupVaultOperationSerializer: HttpSerializer.NonStreaming<CreateBackupVaultRequest> {
    override fun serialize(context: ExecutionContext, input: CreateBackupVaultRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.backupVaultName) { "backupVaultName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("backup-vaults"))
                add(PercentEncoding.SmithyLabel.encode("${input.backupVaultName}"))
            }
        }

        val payload = serializeCreateBackupVaultOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateBackupVaultOperationBody(context: ExecutionContext, input: CreateBackupVaultRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKUPVAULTTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("BackupVaultTags"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val ENCRYPTIONKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionKeyArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTTAGS_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
        field(ENCRYPTIONKEYARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.backupVaultTags != null) {
            mapField(BACKUPVAULTTAGS_DESCRIPTOR) {
                input.backupVaultTags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.creatorRequestId?.let { field(CREATORREQUESTID_DESCRIPTOR, it) }
        input.encryptionKeyArn?.let { field(ENCRYPTIONKEYARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
