// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class ListRecoveryPointsByResourceRequest private constructor(builder: Builder) {
    /**
     * This attribute filters recovery points based on ownership.
     *
     * If this is set to `TRUE`, the response will contain recovery points associated with the selected resources that are managed by Backup.
     *
     * If this is set to `FALSE`, the response will contain all recovery points associated with the selected resource.
     *
     * Type: Boolean
     */
    public val managedByAwsBackupOnly: kotlin.Boolean? = builder.managedByAwsBackupOnly
    /**
     * The maximum number of items to be returned.
     *
     * Amazon RDS requires a value of at least 20.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The next item following a partial list of returned items. For example, if a request is made to return `MaxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRecoveryPointsByResourceRequest(")
        append("managedByAwsBackupOnly=$managedByAwsBackupOnly,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceArn=$resourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = managedByAwsBackupOnly?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRecoveryPointsByResourceRequest

        if (managedByAwsBackupOnly != other.managedByAwsBackupOnly) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This attribute filters recovery points based on ownership.
         *
         * If this is set to `TRUE`, the response will contain recovery points associated with the selected resources that are managed by Backup.
         *
         * If this is set to `FALSE`, the response will contain all recovery points associated with the selected resource.
         *
         * Type: Boolean
         */
        public var managedByAwsBackupOnly: kotlin.Boolean? = null
        /**
         * The maximum number of items to be returned.
         *
         * Amazon RDS requires a value of at least 20.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The next item following a partial list of returned items. For example, if a request is made to return `MaxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        public var resourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceRequest) : this() {
            this.managedByAwsBackupOnly = x.managedByAwsBackupOnly
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceRequest = ListRecoveryPointsByResourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
