// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class ListBackupJobSummariesRequest private constructor(builder: Builder) {
    /**
     * Returns the job count for the specified account.
     *
     * If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs within requestor's account will be returned.
     *
     * Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account in the organization.
     *
     * `AGGREGATE_ALL` aggregates job counts from all accounts within the authenticated organization, then returns the sum.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * This is the period that sets the boundaries for returned results.
     *
     * Acceptable values include
     * + `ONE_DAY` for daily job count for the prior 14 days.
     * + `SEVEN_DAYS` for the aggregated job count for the prior 7 days.
     * + `FOURTEEN_DAYS` for aggregated job count for prior 14 days.
     */
    public val aggregationPeriod: aws.sdk.kotlin.services.backup.model.AggregationPeriod? = builder.aggregationPeriod
    /**
     * This parameter sets the maximum number of items to be returned.
     *
     * The value is an integer. Range of accepted values is from 1 to 500.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * This parameter returns the job count for the specified message category.
     *
     * Example accepted strings include `AccessDenied`, `Success`, and `InvalidParameters`. See [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of accepted MessageCategory strings.
     *
     * The the value ANY returns count of all message categories.
     *
     * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
     */
    public val messageCategory: kotlin.String? = builder.messageCategory
    /**
     * The next item following a partial list of returned resources. For example, if a request is made to return `MaxResults` number of resources, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Returns the job count for the specified resource type. Use request `GetSupportedResourceTypes` to obtain strings for supported resource types.
     *
     * The the value ANY returns count of all resource types.
     *
     * `AGGREGATE_ALL` aggregates job counts for all resource types and returns the sum.
     *
     * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * This parameter returns the job count for jobs with the specified state.
     *
     * The the value ANY returns count of all states.
     *
     * `AGGREGATE_ALL` aggregates job counts for all states and returns the sum.
     *
     * `Completed with issues` is a status found only in the Backup console. For API, this status refers to jobs with a state of `COMPLETED` and a `MessageCategory` with a value other than `SUCCESS`; that is, the status is completed but comes with a status message. To obtain the job count for `Completed with issues`, run two GET requests, and subtract the second, smaller number:
     *
     * GET /audit/backup-job-summaries?AggregationPeriod=FOURTEEN_DAYS&State=COMPLETED
     *
     * GET /audit/backup-job-summaries?AggregationPeriod=FOURTEEN_DAYS&MessageCategory=SUCCESS&State=COMPLETED
     */
    public val state: aws.sdk.kotlin.services.backup.model.BackupJobStatus? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListBackupJobSummariesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBackupJobSummariesRequest(")
        append("accountId=$accountId,")
        append("aggregationPeriod=$aggregationPeriod,")
        append("maxResults=$maxResults,")
        append("messageCategory=$messageCategory,")
        append("nextToken=$nextToken,")
        append("resourceType=$resourceType,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (aggregationPeriod?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (messageCategory?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBackupJobSummariesRequest

        if (accountId != other.accountId) return false
        if (aggregationPeriod != other.aggregationPeriod) return false
        if (maxResults != other.maxResults) return false
        if (messageCategory != other.messageCategory) return false
        if (nextToken != other.nextToken) return false
        if (resourceType != other.resourceType) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListBackupJobSummariesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Returns the job count for the specified account.
         *
         * If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs within requestor's account will be returned.
         *
         * Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account in the organization.
         *
         * `AGGREGATE_ALL` aggregates job counts from all accounts within the authenticated organization, then returns the sum.
         */
        public var accountId: kotlin.String? = null
        /**
         * This is the period that sets the boundaries for returned results.
         *
         * Acceptable values include
         * + `ONE_DAY` for daily job count for the prior 14 days.
         * + `SEVEN_DAYS` for the aggregated job count for the prior 7 days.
         * + `FOURTEEN_DAYS` for aggregated job count for prior 14 days.
         */
        public var aggregationPeriod: aws.sdk.kotlin.services.backup.model.AggregationPeriod? = null
        /**
         * This parameter sets the maximum number of items to be returned.
         *
         * The value is an integer. Range of accepted values is from 1 to 500.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * This parameter returns the job count for the specified message category.
         *
         * Example accepted strings include `AccessDenied`, `Success`, and `InvalidParameters`. See [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of accepted MessageCategory strings.
         *
         * The the value ANY returns count of all message categories.
         *
         * `AGGREGATE_ALL` aggregates job counts for all message categories and returns the sum.
         */
        public var messageCategory: kotlin.String? = null
        /**
         * The next item following a partial list of returned resources. For example, if a request is made to return `MaxResults` number of resources, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Returns the job count for the specified resource type. Use request `GetSupportedResourceTypes` to obtain strings for supported resource types.
         *
         * The the value ANY returns count of all resource types.
         *
         * `AGGREGATE_ALL` aggregates job counts for all resource types and returns the sum.
         *
         * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         */
        public var resourceType: kotlin.String? = null
        /**
         * This parameter returns the job count for jobs with the specified state.
         *
         * The the value ANY returns count of all states.
         *
         * `AGGREGATE_ALL` aggregates job counts for all states and returns the sum.
         *
         * `Completed with issues` is a status found only in the Backup console. For API, this status refers to jobs with a state of `COMPLETED` and a `MessageCategory` with a value other than `SUCCESS`; that is, the status is completed but comes with a status message. To obtain the job count for `Completed with issues`, run two GET requests, and subtract the second, smaller number:
         *
         * GET /audit/backup-job-summaries?AggregationPeriod=FOURTEEN_DAYS&State=COMPLETED
         *
         * GET /audit/backup-job-summaries?AggregationPeriod=FOURTEEN_DAYS&MessageCategory=SUCCESS&State=COMPLETED
         */
        public var state: aws.sdk.kotlin.services.backup.model.BackupJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListBackupJobSummariesRequest) : this() {
            this.accountId = x.accountId
            this.aggregationPeriod = x.aggregationPeriod
            this.maxResults = x.maxResults
            this.messageCategory = x.messageCategory
            this.nextToken = x.nextToken
            this.resourceType = x.resourceType
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListBackupJobSummariesRequest = ListBackupJobSummariesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
