// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class DescribeRegionSettingsResponse private constructor(builder: Builder) {
    /**
     * Returns whether Backup fully manages the backups for a resource type.
     *
     * For the benefits of full Backup management, see [ Full Backup management](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management).
     *
     * For a list of resource types and whether each supports full Backup management, see the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
     *
     * If `"DynamoDB":false`, you can enable full Backup management for DynamoDB backup by enabling [ Backup's advanced DynamoDB backup features](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli).
     */
    public val resourceTypeManagementPreference: Map<String, Boolean>? = builder.resourceTypeManagementPreference
    /**
     * Returns a list of all services along with the opt-in preferences in the Region.
     */
    public val resourceTypeOptInPreference: Map<String, Boolean>? = builder.resourceTypeOptInPreference

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.DescribeRegionSettingsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRegionSettingsResponse(")
        append("resourceTypeManagementPreference=$resourceTypeManagementPreference,")
        append("resourceTypeOptInPreference=$resourceTypeOptInPreference")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceTypeManagementPreference?.hashCode() ?: 0
        result = 31 * result + (resourceTypeOptInPreference?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRegionSettingsResponse

        if (resourceTypeManagementPreference != other.resourceTypeManagementPreference) return false
        if (resourceTypeOptInPreference != other.resourceTypeOptInPreference) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.DescribeRegionSettingsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Returns whether Backup fully manages the backups for a resource type.
         *
         * For the benefits of full Backup management, see [ Full Backup management](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management).
         *
         * For a list of resource types and whether each supports full Backup management, see the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
         *
         * If `"DynamoDB":false`, you can enable full Backup management for DynamoDB backup by enabling [ Backup's advanced DynamoDB backup features](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli).
         */
        public var resourceTypeManagementPreference: Map<String, Boolean>? = null
        /**
         * Returns a list of all services along with the opt-in preferences in the Region.
         */
        public var resourceTypeOptInPreference: Map<String, Boolean>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.DescribeRegionSettingsResponse) : this() {
            this.resourceTypeManagementPreference = x.resourceTypeManagementPreference
            this.resourceTypeOptInPreference = x.resourceTypeOptInPreference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.DescribeRegionSettingsResponse = DescribeRegionSettingsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
