// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeBackupJobResponse private constructor(builder: Builder) {
    /**
     * Returns the account ID that owns the backup job.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * Uniquely identifies a request to Backup to back up a resource.
     */
    public val backupJobId: kotlin.String? = builder.backupJobId
    /**
     * Represents the options specified as part of backup plan or on-demand backup job.
     */
    public val backupOptions: Map<String, String>? = builder.backupOptions
    /**
     * The size, in bytes, of a backup.
     */
    public val backupSizeInBytes: kotlin.Long? = builder.backupSizeInBytes
    /**
     * Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, `BackupType` returns `"WindowsVSS"`. If `BackupType` is empty, then the backup type was a regular backup.
     */
    public val backupType: kotlin.String? = builder.backupType
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The size in bytes transferred to a backup vault at the time that the job status was queried.
     */
    public val bytesTransferred: kotlin.Long? = builder.bytesTransferred
    /**
     * This returns the statistics of the included child (nested) backup jobs.
     */
    public val childJobsInState: Map<BackupJobState, Long>? = builder.childJobsInState
    /**
     * The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * Contains identifying information about the creation of a backup job, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan that is used to create it.
     */
    public val createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = builder.createdBy
    /**
     * The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of `ExpectedCompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val expectedCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expectedCompletionDate
    /**
     * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * This is the date a backup job was initiated.
     */
    public val initiationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.initiationDate
    /**
     * This returns the boolean value that a backup job is a parent (composite) job.
     */
    public val isParent: kotlin.Boolean = builder.isParent
    /**
     * This is the job count for the specified message category.
     *
     * Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`, and `INVALIDPARAMETERS`. View [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of accepted MessageCategory strings.
     */
    public val messageCategory: kotlin.String? = builder.messageCategory
    /**
     * This returns the number of child (nested) backup jobs.
     */
    public val numberOfChildJobs: kotlin.Long? = builder.numberOfChildJobs
    /**
     * This returns the parent (composite) resource backup job ID.
     */
    public val parentJobId: kotlin.String? = builder.parentJobId
    /**
     * Contains an estimated percentage that is complete of a job at the time the job status was queried.
     */
    public val percentDone: kotlin.String? = builder.percentDone
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * This is the non-unique name of the resource that belongs to the specified backup.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the `StartBy` time would be 8:00 PM on the date specified. The value of `StartBy` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val startBy: aws.smithy.kotlin.runtime.time.Instant? = builder.startBy
    /**
     * The current state of a backup job.
     */
    public val state: aws.sdk.kotlin.services.backup.model.BackupJobState? = builder.state
    /**
     * A detailed message explaining the status of the job to back up a resource.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.DescribeBackupJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBackupJobResponse(")
        append("accountId=$accountId,")
        append("backupJobId=$backupJobId,")
        append("backupOptions=$backupOptions,")
        append("backupSizeInBytes=$backupSizeInBytes,")
        append("backupType=$backupType,")
        append("backupVaultArn=$backupVaultArn,")
        append("backupVaultName=$backupVaultName,")
        append("bytesTransferred=$bytesTransferred,")
        append("childJobsInState=$childJobsInState,")
        append("completionDate=$completionDate,")
        append("createdBy=$createdBy,")
        append("creationDate=$creationDate,")
        append("expectedCompletionDate=$expectedCompletionDate,")
        append("iamRoleArn=$iamRoleArn,")
        append("initiationDate=$initiationDate,")
        append("isParent=$isParent,")
        append("messageCategory=$messageCategory,")
        append("numberOfChildJobs=$numberOfChildJobs,")
        append("parentJobId=$parentJobId,")
        append("percentDone=$percentDone,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceArn=$resourceArn,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("startBy=$startBy,")
        append("state=$state,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (backupJobId?.hashCode() ?: 0)
        result = 31 * result + (backupOptions?.hashCode() ?: 0)
        result = 31 * result + (backupSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (backupType?.hashCode() ?: 0)
        result = 31 * result + (backupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (bytesTransferred?.hashCode() ?: 0)
        result = 31 * result + (childJobsInState?.hashCode() ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (expectedCompletionDate?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (initiationDate?.hashCode() ?: 0)
        result = 31 * result + (isParent.hashCode())
        result = 31 * result + (messageCategory?.hashCode() ?: 0)
        result = 31 * result + (numberOfChildJobs?.hashCode() ?: 0)
        result = 31 * result + (parentJobId?.hashCode() ?: 0)
        result = 31 * result + (percentDone?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (startBy?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeBackupJobResponse

        if (accountId != other.accountId) return false
        if (backupJobId != other.backupJobId) return false
        if (backupOptions != other.backupOptions) return false
        if (backupSizeInBytes != other.backupSizeInBytes) return false
        if (backupType != other.backupType) return false
        if (backupVaultArn != other.backupVaultArn) return false
        if (backupVaultName != other.backupVaultName) return false
        if (bytesTransferred != other.bytesTransferred) return false
        if (childJobsInState != other.childJobsInState) return false
        if (completionDate != other.completionDate) return false
        if (createdBy != other.createdBy) return false
        if (creationDate != other.creationDate) return false
        if (expectedCompletionDate != other.expectedCompletionDate) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (initiationDate != other.initiationDate) return false
        if (isParent != other.isParent) return false
        if (messageCategory != other.messageCategory) return false
        if (numberOfChildJobs != other.numberOfChildJobs) return false
        if (parentJobId != other.parentJobId) return false
        if (percentDone != other.percentDone) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (startBy != other.startBy) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.DescribeBackupJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Returns the account ID that owns the backup job.
         */
        public var accountId: kotlin.String? = null
        /**
         * Uniquely identifies a request to Backup to back up a resource.
         */
        public var backupJobId: kotlin.String? = null
        /**
         * Represents the options specified as part of backup plan or on-demand backup job.
         */
        public var backupOptions: Map<String, String>? = null
        /**
         * The size, in bytes, of a backup.
         */
        public var backupSizeInBytes: kotlin.Long? = null
        /**
         * Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, `BackupType` returns `"WindowsVSS"`. If `BackupType` is empty, then the backup type was a regular backup.
         */
        public var backupType: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The size in bytes transferred to a backup vault at the time that the job status was queried.
         */
        public var bytesTransferred: kotlin.Long? = null
        /**
         * This returns the statistics of the included child (nested) backup jobs.
         */
        public var childJobsInState: Map<BackupJobState, Long>? = null
        /**
         * The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains identifying information about the creation of a backup job, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan that is used to create it.
         */
        public var createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = null
        /**
         * The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of `ExpectedCompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var expectedCompletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * This is the date a backup job was initiated.
         */
        public var initiationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This returns the boolean value that a backup job is a parent (composite) job.
         */
        public var isParent: kotlin.Boolean = false
        /**
         * This is the job count for the specified message category.
         *
         * Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`, and `INVALIDPARAMETERS`. View [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html) for a list of accepted MessageCategory strings.
         */
        public var messageCategory: kotlin.String? = null
        /**
         * This returns the number of child (nested) backup jobs.
         */
        public var numberOfChildJobs: kotlin.Long? = null
        /**
         * This returns the parent (composite) resource backup job ID.
         */
        public var parentJobId: kotlin.String? = null
        /**
         * Contains an estimated percentage that is complete of a job at the time the job status was queried.
         */
        public var percentDone: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * This is the non-unique name of the resource that belongs to the specified backup.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         */
        public var resourceType: kotlin.String? = null
        /**
         * Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the `StartBy` time would be 8:00 PM on the date specified. The value of `StartBy` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var startBy: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of a backup job.
         */
        public var state: aws.sdk.kotlin.services.backup.model.BackupJobState? = null
        /**
         * A detailed message explaining the status of the job to back up a resource.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.DescribeBackupJobResponse) : this() {
            this.accountId = x.accountId
            this.backupJobId = x.backupJobId
            this.backupOptions = x.backupOptions
            this.backupSizeInBytes = x.backupSizeInBytes
            this.backupType = x.backupType
            this.backupVaultArn = x.backupVaultArn
            this.backupVaultName = x.backupVaultName
            this.bytesTransferred = x.bytesTransferred
            this.childJobsInState = x.childJobsInState
            this.completionDate = x.completionDate
            this.createdBy = x.createdBy
            this.creationDate = x.creationDate
            this.expectedCompletionDate = x.expectedCompletionDate
            this.iamRoleArn = x.iamRoleArn
            this.initiationDate = x.initiationDate
            this.isParent = x.isParent
            this.messageCategory = x.messageCategory
            this.numberOfChildJobs = x.numberOfChildJobs
            this.parentJobId = x.parentJobId
            this.percentDone = x.percentDone
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceArn = x.resourceArn
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.startBy = x.startBy
            this.state = x.state
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.DescribeBackupJobResponse = DescribeBackupJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RecoveryPointCreator] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
