// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.DescribeFrameworkResponse
import aws.sdk.kotlin.services.backup.model.FrameworkControl
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeFrameworkOperationDeserializer: HttpDeserialize<DescribeFrameworkResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeFrameworkResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFrameworkError(context, call)
        }
        val builder = DescribeFrameworkResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFrameworkOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeFrameworkError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFrameworkOperationBody(builder: DescribeFrameworkResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeploymentStatus"))
    val FRAMEWORKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FrameworkArn"))
    val FRAMEWORKCONTROLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FrameworkControls"))
    val FRAMEWORKDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FrameworkDescription"))
    val FRAMEWORKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FrameworkName"))
    val FRAMEWORKSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FrameworkStatus"))
    val IDEMPOTENCYTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdempotencyToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DEPLOYMENTSTATUS_DESCRIPTOR)
        field(FRAMEWORKARN_DESCRIPTOR)
        field(FRAMEWORKCONTROLS_DESCRIPTOR)
        field(FRAMEWORKDESCRIPTION_DESCRIPTOR)
        field(FRAMEWORKNAME_DESCRIPTOR)
        field(FRAMEWORKSTATUS_DESCRIPTOR)
        field(IDEMPOTENCYTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.deploymentStatus = deserializeString()
                FRAMEWORKARN_DESCRIPTOR.index -> builder.frameworkArn = deserializeString()
                FRAMEWORKCONTROLS_DESCRIPTOR.index -> builder.frameworkControls =
                    deserializer.deserializeList(FRAMEWORKCONTROLS_DESCRIPTOR) {
                        val col0 = mutableListOf<FrameworkControl>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFrameworkControlDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FRAMEWORKDESCRIPTION_DESCRIPTOR.index -> builder.frameworkDescription = deserializeString()
                FRAMEWORKNAME_DESCRIPTOR.index -> builder.frameworkName = deserializeString()
                FRAMEWORKSTATUS_DESCRIPTOR.index -> builder.frameworkStatus = deserializeString()
                IDEMPOTENCYTOKEN_DESCRIPTOR.index -> builder.idempotencyToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
