// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupSelection
import aws.sdk.kotlin.services.backup.model.CreateBackupSelectionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateBackupSelectionOperationSerializer: HttpSerialize<CreateBackupSelectionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateBackupSelectionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.backupPlanId) { "backupPlanId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("backup"))
                add(PercentEncoding.Path.encode("plans"))
                add(PercentEncoding.SmithyLabel.encode("${input.backupPlanId}"))
                add(PercentEncoding.Path.encode("selections"))
            }
        }

        val payload = serializeCreateBackupSelectionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateBackupSelectionOperationBody(context: ExecutionContext, input: CreateBackupSelectionRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKUPSELECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BackupSelection"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPSELECTION_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.backupSelection?.let { field(BACKUPSELECTION_DESCRIPTOR, it, ::serializeBackupSelectionDocument) }
        input.creatorRequestId?.let { field(CREATORREQUESTID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
