// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This is a summary of restore jobs created or running within the most recent 30 days.
 *
 * The returned summary may contain the following: Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
 */
public class RestoreJobSummary private constructor(builder: Builder) {
    /**
     * The account ID that owns the jobs within the summary.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The value as a number of jobs in a job summary.
     */
    public val count: kotlin.Int = builder.count
    /**
     * The value of time in number format of a job end time.
     *
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Web Services Regions within the job summary.
     */
    public val region: kotlin.String? = builder.region
    /**
     * This value is the job count for the specified resource type. The request `GetSupportedResourceTypes` returns strings for supported resource types.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The value of time in number format of a job start time.
     *
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * This value is job count for jobs with the specified state.
     */
    public val state: aws.sdk.kotlin.services.backup.model.RestoreJobState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RestoreJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreJobSummary(")
        append("accountId=$accountId,")
        append("count=$count,")
        append("endTime=$endTime,")
        append("region=$region,")
        append("resourceType=$resourceType,")
        append("startTime=$startTime,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (count)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreJobSummary

        if (accountId != other.accountId) return false
        if (count != other.count) return false
        if (endTime != other.endTime) return false
        if (region != other.region) return false
        if (resourceType != other.resourceType) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RestoreJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account ID that owns the jobs within the summary.
         */
        public var accountId: kotlin.String? = null
        /**
         * The value as a number of jobs in a job summary.
         */
        public var count: kotlin.Int = 0
        /**
         * The value of time in number format of a job end time.
         *
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Regions within the job summary.
         */
        public var region: kotlin.String? = null
        /**
         * This value is the job count for the specified resource type. The request `GetSupportedResourceTypes` returns strings for supported resource types.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The value of time in number format of a job start time.
         *
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This value is job count for jobs with the specified state.
         */
        public var state: aws.sdk.kotlin.services.backup.model.RestoreJobState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RestoreJobSummary) : this() {
            this.accountId = x.accountId
            this.count = x.count
            this.endTime = x.endTime
            this.region = x.region
            this.resourceType = x.resourceType
            this.startTime = x.startTime
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RestoreJobSummary = RestoreJobSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
