// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Contains detailed information about a report setting.
 */
public class ReportSetting private constructor(builder: Builder) {
    /**
     * These are the accounts to be included in the report.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * The Amazon Resource Names (ARNs) of the frameworks a report covers.
     */
    public val frameworkArns: List<String>? = builder.frameworkArns
    /**
     * The number of frameworks a report covers.
     */
    public val numberOfFrameworks: kotlin.Int = builder.numberOfFrameworks
    /**
     * These are the Organizational Units to be included in the report.
     */
    public val organizationUnits: List<String>? = builder.organizationUnits
    /**
     * These are the Regions to be included in the report.
     */
    public val regions: List<String>? = builder.regions
    /**
     * Identifies the report template for the report. Reports are built using a report template. The report templates are:
     *
     * `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
     */
    public val reportTemplate: kotlin.String = requireNotNull(builder.reportTemplate) { "A non-null value must be provided for reportTemplate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ReportSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportSetting(")
        append("accounts=$accounts,")
        append("frameworkArns=$frameworkArns,")
        append("numberOfFrameworks=$numberOfFrameworks,")
        append("organizationUnits=$organizationUnits,")
        append("regions=$regions,")
        append("reportTemplate=$reportTemplate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (frameworkArns?.hashCode() ?: 0)
        result = 31 * result + (numberOfFrameworks)
        result = 31 * result + (organizationUnits?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (reportTemplate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportSetting

        if (accounts != other.accounts) return false
        if (frameworkArns != other.frameworkArns) return false
        if (numberOfFrameworks != other.numberOfFrameworks) return false
        if (organizationUnits != other.organizationUnits) return false
        if (regions != other.regions) return false
        if (reportTemplate != other.reportTemplate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ReportSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * These are the accounts to be included in the report.
         */
        public var accounts: List<String>? = null
        /**
         * The Amazon Resource Names (ARNs) of the frameworks a report covers.
         */
        public var frameworkArns: List<String>? = null
        /**
         * The number of frameworks a report covers.
         */
        public var numberOfFrameworks: kotlin.Int = 0
        /**
         * These are the Organizational Units to be included in the report.
         */
        public var organizationUnits: List<String>? = null
        /**
         * These are the Regions to be included in the report.
         */
        public var regions: List<String>? = null
        /**
         * Identifies the report template for the report. Reports are built using a report template. The report templates are:
         *
         * `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
         */
        public var reportTemplate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ReportSetting) : this() {
            this.accounts = x.accounts
            this.frameworkArns = x.frameworkArns
            this.numberOfFrameworks = x.numberOfFrameworks
            this.organizationUnits = x.organizationUnits
            this.regions = x.regions
            this.reportTemplate = x.reportTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ReportSetting = ReportSetting(this)

        internal fun correctErrors(): Builder {
            if (reportTemplate == null) reportTemplate = ""
            return this
        }
    }
}
