// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class CreateLogicallyAirGappedBackupVaultRequest private constructor(builder: Builder) {
    /**
     * This is the name of the vault that is being created.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * These are the tags that will be included in the newly-created vault.
     */
    public val backupVaultTags: Map<String, String>? = builder.backupVaultTags
    /**
     * This is the ID of the creation request.
     *
     * This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * This is the setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Backup does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).
     *
     * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault.
     */
    public val maxRetentionDays: kotlin.Long? = builder.maxRetentionDays
    /**
     * This setting specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, no minimum retention period is enforced.
     *
     * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If a job retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault.
     */
    public val minRetentionDays: kotlin.Long? = builder.minRetentionDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLogicallyAirGappedBackupVaultRequest(")
        append("backupVaultName=$backupVaultName,")
        append("backupVaultTags=*** Sensitive Data Redacted ***,")
        append("creatorRequestId=$creatorRequestId,")
        append("maxRetentionDays=$maxRetentionDays,")
        append("minRetentionDays=$minRetentionDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultName?.hashCode() ?: 0
        result = 31 * result + (backupVaultTags?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (maxRetentionDays?.hashCode() ?: 0)
        result = 31 * result + (minRetentionDays?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLogicallyAirGappedBackupVaultRequest

        if (backupVaultName != other.backupVaultName) return false
        if (backupVaultTags != other.backupVaultTags) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (maxRetentionDays != other.maxRetentionDays) return false
        if (minRetentionDays != other.minRetentionDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is the name of the vault that is being created.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * These are the tags that will be included in the newly-created vault.
         */
        public var backupVaultTags: Map<String, String>? = null
        /**
         * This is the ID of the creation request.
         *
         * This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * This is the setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Backup does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).
         *
         * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault.
         */
        public var maxRetentionDays: kotlin.Long? = null
        /**
         * This setting specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, no minimum retention period is enforced.
         *
         * If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If a job retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault.
         */
        public var minRetentionDays: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest) : this() {
            this.backupVaultName = x.backupVaultName
            this.backupVaultTags = x.backupVaultTags
            this.creatorRequestId = x.creatorRequestId
            this.maxRetentionDays = x.maxRetentionDays
            this.minRetentionDays = x.minRetentionDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest = CreateLogicallyAirGappedBackupVaultRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
