// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Contains an array of triplets made up of a condition type (such as `StringEquals`), a key, and a value. Used to filter resources using their tags and assign them to a backup plan. Case sensitive.
 */
public class Condition private constructor(builder: Builder) {
    /**
     * The key in a key-value pair. For example, in the tag `Department: Accounting`, `Department` is the key.
     */
    public val conditionKey: kotlin.String = requireNotNull(builder.conditionKey) { "A non-null value must be provided for conditionKey" }
    /**
     * An operation applied to a key-value pair used to assign resources to your backup plan. Condition only supports `StringEquals`. For more flexible assignment options, including `StringLike` and the ability to exclude resources from your backup plan, use `Conditions` (with an "s" on the end) for your `BackupSelection`[](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html).
     */
    public val conditionType: aws.sdk.kotlin.services.backup.model.ConditionType = requireNotNull(builder.conditionType) { "A non-null value must be provided for conditionType" }
    /**
     * The value in a key-value pair. For example, in the tag `Department: Accounting`, `Accounting` is the value.
     */
    public val conditionValue: kotlin.String = requireNotNull(builder.conditionValue) { "A non-null value must be provided for conditionValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.Condition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Condition(")
        append("conditionKey=$conditionKey,")
        append("conditionType=$conditionType,")
        append("conditionValue=$conditionValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = conditionKey.hashCode()
        result = 31 * result + (conditionType.hashCode())
        result = 31 * result + (conditionValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Condition

        if (conditionKey != other.conditionKey) return false
        if (conditionType != other.conditionType) return false
        if (conditionValue != other.conditionValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.Condition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The key in a key-value pair. For example, in the tag `Department: Accounting`, `Department` is the key.
         */
        public var conditionKey: kotlin.String? = null
        /**
         * An operation applied to a key-value pair used to assign resources to your backup plan. Condition only supports `StringEquals`. For more flexible assignment options, including `StringLike` and the ability to exclude resources from your backup plan, use `Conditions` (with an "s" on the end) for your `BackupSelection`[](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html).
         */
        public var conditionType: aws.sdk.kotlin.services.backup.model.ConditionType? = null
        /**
         * The value in a key-value pair. For example, in the tag `Department: Accounting`, `Accounting` is the value.
         */
        public var conditionValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.Condition) : this() {
            this.conditionKey = x.conditionKey
            this.conditionType = x.conditionType
            this.conditionValue = x.conditionValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.Condition = Condition(this)

        internal fun correctErrors(): Builder {
            if (conditionKey == null) conditionKey = ""
            if (conditionType == null) conditionType = ConditionType.SdkUnknown("no value provided")
            if (conditionValue == null) conditionValue = ""
            return this
        }
    }
}
