// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about a `BackupSelection` object.
 */
public class BackupSelectionsListMember private constructor(builder: Builder) {
    /**
     * Uniquely identifies a backup plan.
     */
    public val backupPlanId: kotlin.String? = builder.backupPlanId
    /**
     * The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.
     *
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * Uniquely identifies a request to assign a set of resources to a backup plan.
     */
    public val selectionId: kotlin.String? = builder.selectionId
    /**
     * The display name of a resource selection document.
     */
    public val selectionName: kotlin.String? = builder.selectionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupSelectionsListMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupSelectionsListMember(")
        append("backupPlanId=$backupPlanId,")
        append("creationDate=$creationDate,")
        append("creatorRequestId=$creatorRequestId,")
        append("iamRoleArn=$iamRoleArn,")
        append("selectionId=$selectionId,")
        append("selectionName=$selectionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupPlanId?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (selectionId?.hashCode() ?: 0)
        result = 31 * result + (selectionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupSelectionsListMember

        if (backupPlanId != other.backupPlanId) return false
        if (creationDate != other.creationDate) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (selectionId != other.selectionId) return false
        if (selectionName != other.selectionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupSelectionsListMember = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Uniquely identifies a backup plan.
         */
        public var backupPlanId: kotlin.String? = null
        /**
         * The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.
         *
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * Uniquely identifies a request to assign a set of resources to a backup plan.
         */
        public var selectionId: kotlin.String? = null
        /**
         * The display name of a resource selection document.
         */
        public var selectionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupSelectionsListMember) : this() {
            this.backupPlanId = x.backupPlanId
            this.creationDate = x.creationDate
            this.creatorRequestId = x.creatorRequestId
            this.iamRoleArn = x.iamRoleArn
            this.selectionId = x.selectionId
            this.selectionName = x.selectionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupSelectionsListMember = BackupSelectionsListMember(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
