// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.backup.auth.BackupAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.backup.auth.BackupIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.backup.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.backup.model.*
import aws.sdk.kotlin.services.backup.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultBackupClient(override val config: BackupClient.Config) : BackupClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = BackupIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "backup")
        }
        toMap()
    }
    private val authSchemeAdapter = BackupAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.backup"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user with sufficient permissions.
     */
    override suspend fun cancelLegalHold(input: CancelLegalHoldRequest): CancelLegalHoldResponse {
        val op = SdkHttpOperation.build<CancelLegalHoldRequest, CancelLegalHoldResponse> {
            serializer = CancelLegalHoldOperationSerializer()
            deserializer = CancelLegalHoldOperationDeserializer()
            operationName = "CancelLegalHold"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.
     *
     * If you call `CreateBackupPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    override suspend fun createBackupPlan(input: CreateBackupPlanRequest): CreateBackupPlanResponse {
        val op = SdkHttpOperation.build<CreateBackupPlanRequest, CreateBackupPlanResponse> {
            serializer = CreateBackupPlanOperationSerializer()
            deserializer = CreateBackupPlanOperationDeserializer()
            operationName = "CreateBackupPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see [Assigning resources programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
     */
    override suspend fun createBackupSelection(input: CreateBackupSelectionRequest): CreateBackupSelectionResponse {
        val op = SdkHttpOperation.build<CreateBackupSelectionRequest, CreateBackupSelectionResponse> {
            serializer = CreateBackupSelectionOperationSerializer()
            deserializer = CreateBackupSelectionOperationDeserializer()
            operationName = "CreateBackupSelection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a logical container where backups are stored. A `CreateBackupVault` request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
     *
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     */
    override suspend fun createBackupVault(input: CreateBackupVaultRequest): CreateBackupVaultResponse {
        val op = SdkHttpOperation.build<CreateBackupVaultRequest, CreateBackupVaultResponse> {
            serializer = CreateBackupVaultOperationSerializer()
            deserializer = CreateBackupVaultOperationDeserializer()
            operationName = "CreateBackupVault"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     */
    override suspend fun createFramework(input: CreateFrameworkRequest): CreateFrameworkResponse {
        val op = SdkHttpOperation.build<CreateFrameworkRequest, CreateFrameworkResponse> {
            serializer = CreateFrameworkOperationSerializer()
            deserializer = CreateFrameworkOperationDeserializer()
            operationName = "CreateFramework"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a recovery point will fail with an error if one or more active legal holds are on the recovery point.
     */
    override suspend fun createLegalHold(input: CreateLegalHoldRequest): CreateLegalHoldResponse {
        val op = SdkHttpOperation.build<CreateLegalHoldRequest, CreateLegalHoldResponse> {
            serializer = CreateLegalHoldOperationSerializer()
            deserializer = CreateLegalHoldOperationDeserializer()
            operationName = "CreateLegalHold"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request creates a logical container to where backups may be copied.
     *
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention days, and optionally can include tags and a creator request ID.
     *
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     */
    override suspend fun createLogicallyAirGappedBackupVault(input: CreateLogicallyAirGappedBackupVaultRequest): CreateLogicallyAirGappedBackupVaultResponse {
        val op = SdkHttpOperation.build<CreateLogicallyAirGappedBackupVaultRequest, CreateLogicallyAirGappedBackupVaultResponse> {
            serializer = CreateLogicallyAirGappedBackupVaultOperationSerializer()
            deserializer = CreateLogicallyAirGappedBackupVaultOperationDeserializer()
            operationName = "CreateLogicallyAirGappedBackupVault"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.
     *
     * If you call `CreateReportPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    override suspend fun createReportPlan(input: CreateReportPlanRequest): CreateReportPlanResponse {
        val op = SdkHttpOperation.build<CreateReportPlanRequest, CreateReportPlanResponse> {
            serializer = CreateReportPlanOperationSerializer()
            deserializer = CreateReportPlanOperationDeserializer()
            operationName = "CreateReportPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This is the first of two steps to create a restore testing plan; once this request is successful, finish the procedure with request CreateRestoreTestingSelection.
     *
     * You must include the parameter RestoreTestingPlan. You may optionally include CreatorRequestId and Tags.
     */
    override suspend fun createRestoreTestingPlan(input: CreateRestoreTestingPlanRequest): CreateRestoreTestingPlanResponse {
        val op = SdkHttpOperation.build<CreateRestoreTestingPlanRequest, CreateRestoreTestingPlanResponse> {
            serializer = CreateRestoreTestingPlanOperationSerializer()
            deserializer = CreateRestoreTestingPlanOperationDeserializer()
            operationName = "CreateRestoreTestingPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request can be sent after CreateRestoreTestingPlan request returns successfully. This is the second part of creating a resource testing plan, and it must be completed sequentially.
     *
     * This consists of `RestoreTestingSelectionName`, `ProtectedResourceType`, and one of the following:
     * + `ProtectedResourceArns`
     * + `ProtectedResourceConditions`
     *
     * Each protected resource type can have one single value.
     *
     * A restore testing selection can include a wildcard value ("*") for `ProtectedResourceArns` along with `ProtectedResourceConditions`. Alternatively, you can include up to 30 specific protected resource ARNs in `ProtectedResourceArns`.
     *
     * Cannot select by both protected resource types AND specific ARNs. Request will fail if both are included.
     */
    override suspend fun createRestoreTestingSelection(input: CreateRestoreTestingSelectionRequest): CreateRestoreTestingSelectionResponse {
        val op = SdkHttpOperation.build<CreateRestoreTestingSelectionRequest, CreateRestoreTestingSelectionResponse> {
            serializer = CreateRestoreTestingSelectionOperationSerializer()
            deserializer = CreateRestoreTestingSelectionOperationDeserializer()
            operationName = "CreateRestoreTestingSelection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.
     */
    override suspend fun deleteBackupPlan(input: DeleteBackupPlanRequest): DeleteBackupPlanResponse {
        val op = SdkHttpOperation.build<DeleteBackupPlanRequest, DeleteBackupPlanResponse> {
            serializer = DeleteBackupPlanOperationSerializer()
            deserializer = DeleteBackupPlanOperationDeserializer()
            operationName = "DeleteBackupPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the resource selection associated with a backup plan that is specified by the `SelectionId`.
     */
    override suspend fun deleteBackupSelection(input: DeleteBackupSelectionRequest): DeleteBackupSelectionResponse {
        val op = SdkHttpOperation.build<DeleteBackupSelectionRequest, DeleteBackupSelectionResponse> {
            serializer = DeleteBackupSelectionOperationSerializer()
            deserializer = DeleteBackupSelectionOperationDeserializer()
            operationName = "DeleteBackupSelection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     */
    override suspend fun deleteBackupVault(input: DeleteBackupVaultRequest): DeleteBackupVaultResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultRequest, DeleteBackupVaultResponse> {
            serializer = DeleteBackupVaultOperationSerializer()
            deserializer = DeleteBackupVaultOperationDeserializer()
            operationName = "DeleteBackupVault"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the policy document that manages permissions on a backup vault.
     */
    override suspend fun deleteBackupVaultAccessPolicy(input: DeleteBackupVaultAccessPolicyRequest): DeleteBackupVaultAccessPolicyResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultAccessPolicyRequest, DeleteBackupVaultAccessPolicyResponse> {
            serializer = DeleteBackupVaultAccessPolicyOperationSerializer()
            deserializer = DeleteBackupVaultAccessPolicyOperationDeserializer()
            operationName = "DeleteBackupVaultAccessPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     *
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an `InvalidRequestException` if you attempt to do so. For more information, see [Vault Lock](https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html) in the *Backup Developer Guide*.
     */
    override suspend fun deleteBackupVaultLockConfiguration(input: DeleteBackupVaultLockConfigurationRequest): DeleteBackupVaultLockConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultLockConfigurationRequest, DeleteBackupVaultLockConfigurationResponse> {
            serializer = DeleteBackupVaultLockConfigurationOperationSerializer()
            deserializer = DeleteBackupVaultLockConfigurationOperationDeserializer()
            operationName = "DeleteBackupVaultLockConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes event notifications for the specified backup vault.
     */
    override suspend fun deleteBackupVaultNotifications(input: DeleteBackupVaultNotificationsRequest): DeleteBackupVaultNotificationsResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultNotificationsRequest, DeleteBackupVaultNotificationsResponse> {
            serializer = DeleteBackupVaultNotificationsOperationSerializer()
            deserializer = DeleteBackupVaultNotificationsOperationDeserializer()
            operationName = "DeleteBackupVaultNotifications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the framework specified by a framework name.
     */
    override suspend fun deleteFramework(input: DeleteFrameworkRequest): DeleteFrameworkResponse {
        val op = SdkHttpOperation.build<DeleteFrameworkRequest, DeleteFrameworkResponse> {
            serializer = DeleteFrameworkOperationSerializer()
            deserializer = DeleteFrameworkOperationDeserializer()
            operationName = "DeleteFramework"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the recovery point specified by a recovery point ID.
     *
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.
     *
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an `EXPIRED` state.
     *
     * `EXPIRED` recovery points can be deleted with this API once the IAM role has the `iam:CreateServiceLinkedRole` action. To learn more about adding this role, see [ Troubleshooting manual deletions](https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting).
     *
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful and will enter an `EXPIRED` state.
     */
    override suspend fun deleteRecoveryPoint(input: DeleteRecoveryPointRequest): DeleteRecoveryPointResponse {
        val op = SdkHttpOperation.build<DeleteRecoveryPointRequest, DeleteRecoveryPointResponse> {
            serializer = DeleteRecoveryPointOperationSerializer()
            deserializer = DeleteRecoveryPointOperationDeserializer()
            operationName = "DeleteRecoveryPoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the report plan specified by a report plan name.
     */
    override suspend fun deleteReportPlan(input: DeleteReportPlanRequest): DeleteReportPlanResponse {
        val op = SdkHttpOperation.build<DeleteReportPlanRequest, DeleteReportPlanResponse> {
            serializer = DeleteReportPlanOperationSerializer()
            deserializer = DeleteReportPlanOperationDeserializer()
            operationName = "DeleteReportPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request deletes the specified restore testing plan.
     *
     * Deletion can only successfully occur if all associated restore testing selections are deleted first.
     */
    override suspend fun deleteRestoreTestingPlan(input: DeleteRestoreTestingPlanRequest): DeleteRestoreTestingPlanResponse {
        val op = SdkHttpOperation.build<DeleteRestoreTestingPlanRequest, DeleteRestoreTestingPlanResponse> {
            serializer = DeleteRestoreTestingPlanOperationSerializer()
            deserializer = DeleteRestoreTestingPlanOperationDeserializer()
            operationName = "DeleteRestoreTestingPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Input the Restore Testing Plan name and Restore Testing Selection name.
     *
     * All testing selections associated with a restore testing plan must be deleted before the restore testing plan can be deleted.
     */
    override suspend fun deleteRestoreTestingSelection(input: DeleteRestoreTestingSelectionRequest): DeleteRestoreTestingSelectionResponse {
        val op = SdkHttpOperation.build<DeleteRestoreTestingSelectionRequest, DeleteRestoreTestingSelectionResponse> {
            serializer = DeleteRestoreTestingSelectionOperationSerializer()
            deserializer = DeleteRestoreTestingSelectionOperationDeserializer()
            operationName = "DeleteRestoreTestingSelection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns backup job details for the specified `BackupJobId`.
     */
    override suspend fun describeBackupJob(input: DescribeBackupJobRequest): DescribeBackupJobResponse {
        val op = SdkHttpOperation.build<DescribeBackupJobRequest, DescribeBackupJobResponse> {
            serializer = DescribeBackupJobOperationSerializer()
            deserializer = DescribeBackupJobOperationDeserializer()
            operationName = "DescribeBackupJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about a backup vault specified by its name.
     */
    override suspend fun describeBackupVault(input: DescribeBackupVaultRequest): DescribeBackupVaultResponse {
        val op = SdkHttpOperation.build<DescribeBackupVaultRequest, DescribeBackupVaultResponse> {
            serializer = DescribeBackupVaultOperationSerializer()
            deserializer = DescribeBackupVaultOperationDeserializer()
            operationName = "DescribeBackupVault"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata associated with creating a copy of a resource.
     */
    override suspend fun describeCopyJob(input: DescribeCopyJobRequest): DescribeCopyJobResponse {
        val op = SdkHttpOperation.build<DescribeCopyJobRequest, DescribeCopyJobResponse> {
            serializer = DescribeCopyJobOperationSerializer()
            deserializer = DescribeCopyJobOperationDeserializer()
            operationName = "DescribeCopyJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the framework details for the specified `FrameworkName`.
     */
    override suspend fun describeFramework(input: DescribeFrameworkRequest): DescribeFrameworkResponse {
        val op = SdkHttpOperation.build<DescribeFrameworkRequest, DescribeFrameworkResponse> {
            serializer = DescribeFrameworkOperationSerializer()
            deserializer = DescribeFrameworkOperationDeserializer()
            operationName = "DescribeFramework"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: `describe-global-settings --region us-west-2`
     */
    override suspend fun describeGlobalSettings(input: DescribeGlobalSettingsRequest): DescribeGlobalSettingsResponse {
        val op = SdkHttpOperation.build<DescribeGlobalSettingsRequest, DescribeGlobalSettingsResponse> {
            serializer = DescribeGlobalSettingsOperationSerializer()
            deserializer = DescribeGlobalSettingsOperationDeserializer()
            operationName = "DescribeGlobalSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.
     */
    override suspend fun describeProtectedResource(input: DescribeProtectedResourceRequest): DescribeProtectedResourceResponse {
        val op = SdkHttpOperation.build<DescribeProtectedResourceRequest, DescribeProtectedResourceResponse> {
            serializer = DescribeProtectedResourceOperationSerializer()
            deserializer = DescribeProtectedResourceOperationDeserializer()
            operationName = "DescribeProtectedResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     */
    override suspend fun describeRecoveryPoint(input: DescribeRecoveryPointRequest): DescribeRecoveryPointResponse {
        val op = SdkHttpOperation.build<DescribeRecoveryPointRequest, DescribeRecoveryPointResponse> {
            serializer = DescribeRecoveryPointOperationSerializer()
            deserializer = DescribeRecoveryPointOperationDeserializer()
            operationName = "DescribeRecoveryPoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     */
    override suspend fun describeRegionSettings(input: DescribeRegionSettingsRequest): DescribeRegionSettingsResponse {
        val op = SdkHttpOperation.build<DescribeRegionSettingsRequest, DescribeRegionSettingsResponse> {
            serializer = DescribeRegionSettingsOperationSerializer()
            deserializer = DescribeRegionSettingsOperationDeserializer()
            operationName = "DescribeRegionSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details associated with creating a report as specified by its `ReportJobId`.
     */
    override suspend fun describeReportJob(input: DescribeReportJobRequest): DescribeReportJobResponse {
        val op = SdkHttpOperation.build<DescribeReportJobRequest, DescribeReportJobResponse> {
            serializer = DescribeReportJobOperationSerializer()
            deserializer = DescribeReportJobOperationDeserializer()
            operationName = "DescribeReportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     */
    override suspend fun describeReportPlan(input: DescribeReportPlanRequest): DescribeReportPlanResponse {
        val op = SdkHttpOperation.build<DescribeReportPlanRequest, DescribeReportPlanResponse> {
            serializer = DescribeReportPlanOperationSerializer()
            deserializer = DescribeReportPlanOperationDeserializer()
            operationName = "DescribeReportPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata associated with a restore job that is specified by a job ID.
     */
    override suspend fun describeRestoreJob(input: DescribeRestoreJobRequest): DescribeRestoreJobResponse {
        val op = SdkHttpOperation.build<DescribeRestoreJobRequest, DescribeRestoreJobResponse> {
            serializer = DescribeRestoreJobOperationSerializer()
            deserializer = DescribeRestoreJobOperationDeserializer()
            operationName = "DescribeRestoreJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.
     *
     * Does not support snapshot backup recovery points.
     */
    override suspend fun disassociateRecoveryPoint(input: DisassociateRecoveryPointRequest): DisassociateRecoveryPointResponse {
        val op = SdkHttpOperation.build<DisassociateRecoveryPointRequest, DisassociateRecoveryPointResponse> {
            serializer = DisassociateRecoveryPointOperationSerializer()
            deserializer = DisassociateRecoveryPointOperationDeserializer()
            operationName = "DisassociateRecoveryPoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery point and its parent (composite) recovery point.
     */
    override suspend fun disassociateRecoveryPointFromParent(input: DisassociateRecoveryPointFromParentRequest): DisassociateRecoveryPointFromParentResponse {
        val op = SdkHttpOperation.build<DisassociateRecoveryPointFromParentRequest, DisassociateRecoveryPointFromParentResponse> {
            serializer = DisassociateRecoveryPointFromParentOperationSerializer()
            deserializer = DisassociateRecoveryPointFromParentOperationDeserializer()
            operationName = "DisassociateRecoveryPointFromParent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the backup plan that is specified by the plan ID as a backup template.
     */
    override suspend fun exportBackupPlanTemplate(input: ExportBackupPlanTemplateRequest): ExportBackupPlanTemplateResponse {
        val op = SdkHttpOperation.build<ExportBackupPlanTemplateRequest, ExportBackupPlanTemplateResponse> {
            serializer = ExportBackupPlanTemplateOperationSerializer()
            deserializer = ExportBackupPlanTemplateOperationDeserializer()
            operationName = "ExportBackupPlanTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns `BackupPlan` details for the specified `BackupPlanId`. The details are the body of a backup plan in JSON format, in addition to plan metadata.
     */
    override suspend fun getBackupPlan(input: GetBackupPlanRequest): GetBackupPlanResponse {
        val op = SdkHttpOperation.build<GetBackupPlanRequest, GetBackupPlanResponse> {
            serializer = GetBackupPlanOperationSerializer()
            deserializer = GetBackupPlanOperationDeserializer()
            operationName = "GetBackupPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a valid JSON document specifying a backup plan or an error.
     */
    override suspend fun getBackupPlanFromJson(input: GetBackupPlanFromJsonRequest): GetBackupPlanFromJsonResponse {
        val op = SdkHttpOperation.build<GetBackupPlanFromJsonRequest, GetBackupPlanFromJsonResponse> {
            serializer = GetBackupPlanFromJSONOperationSerializer()
            deserializer = GetBackupPlanFromJSONOperationDeserializer()
            operationName = "GetBackupPlanFromJSON"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the template specified by its `templateId` as a backup plan.
     */
    override suspend fun getBackupPlanFromTemplate(input: GetBackupPlanFromTemplateRequest): GetBackupPlanFromTemplateResponse {
        val op = SdkHttpOperation.build<GetBackupPlanFromTemplateRequest, GetBackupPlanFromTemplateResponse> {
            serializer = GetBackupPlanFromTemplateOperationSerializer()
            deserializer = GetBackupPlanFromTemplateOperationDeserializer()
            operationName = "GetBackupPlanFromTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.
     */
    override suspend fun getBackupSelection(input: GetBackupSelectionRequest): GetBackupSelectionResponse {
        val op = SdkHttpOperation.build<GetBackupSelectionRequest, GetBackupSelectionResponse> {
            serializer = GetBackupSelectionOperationSerializer()
            deserializer = GetBackupSelectionOperationDeserializer()
            operationName = "GetBackupSelection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the access policy document that is associated with the named backup vault.
     */
    override suspend fun getBackupVaultAccessPolicy(input: GetBackupVaultAccessPolicyRequest): GetBackupVaultAccessPolicyResponse {
        val op = SdkHttpOperation.build<GetBackupVaultAccessPolicyRequest, GetBackupVaultAccessPolicyResponse> {
            serializer = GetBackupVaultAccessPolicyOperationSerializer()
            deserializer = GetBackupVaultAccessPolicyOperationDeserializer()
            operationName = "GetBackupVaultAccessPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns event notifications for the specified backup vault.
     */
    override suspend fun getBackupVaultNotifications(input: GetBackupVaultNotificationsRequest): GetBackupVaultNotificationsResponse {
        val op = SdkHttpOperation.build<GetBackupVaultNotificationsRequest, GetBackupVaultNotificationsResponse> {
            serializer = GetBackupVaultNotificationsOperationSerializer()
            deserializer = GetBackupVaultNotificationsOperationDeserializer()
            operationName = "GetBackupVaultNotifications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format, in addition to metadata.
     */
    override suspend fun getLegalHold(input: GetLegalHoldRequest): GetLegalHoldResponse {
        val op = SdkHttpOperation.build<GetLegalHoldRequest, GetLegalHoldResponse> {
            serializer = GetLegalHoldOperationSerializer()
            deserializer = GetLegalHoldOperationDeserializer()
            operationName = "GetLegalHold"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a set of metadata key-value pairs that were used to create the backup.
     */
    override suspend fun getRecoveryPointRestoreMetadata(input: GetRecoveryPointRestoreMetadataRequest): GetRecoveryPointRestoreMetadataResponse {
        val op = SdkHttpOperation.build<GetRecoveryPointRestoreMetadataRequest, GetRecoveryPointRestoreMetadataResponse> {
            serializer = GetRecoveryPointRestoreMetadataOperationSerializer()
            deserializer = GetRecoveryPointRestoreMetadataOperationDeserializer()
            operationName = "GetRecoveryPointRestoreMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request returns the metadata for the specified restore job.
     */
    override suspend fun getRestoreJobMetadata(input: GetRestoreJobMetadataRequest): GetRestoreJobMetadataResponse {
        val op = SdkHttpOperation.build<GetRestoreJobMetadataRequest, GetRestoreJobMetadataResponse> {
            serializer = GetRestoreJobMetadataOperationSerializer()
            deserializer = GetRestoreJobMetadataOperationDeserializer()
            operationName = "GetRestoreJobMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request returns the minimal required set of metadata needed to start a restore job with secure default settings. `BackupVaultName` and `RecoveryPointArn` are required parameters. `BackupVaultAccountId` is an optional parameter.
     */
    override suspend fun getRestoreTestingInferredMetadata(input: GetRestoreTestingInferredMetadataRequest): GetRestoreTestingInferredMetadataResponse {
        val op = SdkHttpOperation.build<GetRestoreTestingInferredMetadataRequest, GetRestoreTestingInferredMetadataResponse> {
            serializer = GetRestoreTestingInferredMetadataOperationSerializer()
            deserializer = GetRestoreTestingInferredMetadataOperationDeserializer()
            operationName = "GetRestoreTestingInferredMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns `RestoreTestingPlan` details for the specified `RestoreTestingPlanName`. The details are the body of a restore testing plan in JSON format, in addition to plan metadata.
     */
    override suspend fun getRestoreTestingPlan(input: GetRestoreTestingPlanRequest): GetRestoreTestingPlanResponse {
        val op = SdkHttpOperation.build<GetRestoreTestingPlanRequest, GetRestoreTestingPlanResponse> {
            serializer = GetRestoreTestingPlanOperationSerializer()
            deserializer = GetRestoreTestingPlanOperationDeserializer()
            operationName = "GetRestoreTestingPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns RestoreTestingSelection, which displays resources and elements of the restore testing plan.
     */
    override suspend fun getRestoreTestingSelection(input: GetRestoreTestingSelectionRequest): GetRestoreTestingSelectionResponse {
        val op = SdkHttpOperation.build<GetRestoreTestingSelectionRequest, GetRestoreTestingSelectionResponse> {
            serializer = GetRestoreTestingSelectionOperationSerializer()
            deserializer = GetRestoreTestingSelectionOperationDeserializer()
            operationName = "GetRestoreTestingSelection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the Amazon Web Services resource types supported by Backup.
     */
    override suspend fun getSupportedResourceTypes(input: GetSupportedResourceTypesRequest): GetSupportedResourceTypesResponse {
        val op = SdkHttpOperation.build<GetSupportedResourceTypesRequest, GetSupportedResourceTypesResponse> {
            serializer = GetSupportedResourceTypesOperationSerializer()
            deserializer = GetSupportedResourceTypesOperationDeserializer()
            operationName = "GetSupportedResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
     *
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
     */
    override suspend fun listBackupJobSummaries(input: ListBackupJobSummariesRequest): ListBackupJobSummariesResponse {
        val op = SdkHttpOperation.build<ListBackupJobSummariesRequest, ListBackupJobSummariesResponse> {
            serializer = ListBackupJobSummariesOperationSerializer()
            deserializer = ListBackupJobSummariesOperationDeserializer()
            operationName = "ListBackupJobSummaries"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these [monitoring tools](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
     */
    override suspend fun listBackupJobs(input: ListBackupJobsRequest): ListBackupJobsResponse {
        val op = SdkHttpOperation.build<ListBackupJobsRequest, ListBackupJobsResponse> {
            serializer = ListBackupJobsOperationSerializer()
            deserializer = ListBackupJobsOperationDeserializer()
            operationName = "ListBackupJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.
     */
    override suspend fun listBackupPlanTemplates(input: ListBackupPlanTemplatesRequest): ListBackupPlanTemplatesResponse {
        val op = SdkHttpOperation.build<ListBackupPlanTemplatesRequest, ListBackupPlanTemplatesResponse> {
            serializer = ListBackupPlanTemplatesOperationSerializer()
            deserializer = ListBackupPlanTemplatesOperationDeserializer()
            operationName = "ListBackupPlanTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.
     */
    override suspend fun listBackupPlanVersions(input: ListBackupPlanVersionsRequest): ListBackupPlanVersionsResponse {
        val op = SdkHttpOperation.build<ListBackupPlanVersionsRequest, ListBackupPlanVersionsResponse> {
            serializer = ListBackupPlanVersionsOperationSerializer()
            deserializer = ListBackupPlanVersionsOperationDeserializer()
            operationName = "ListBackupPlanVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.
     */
    override suspend fun listBackupPlans(input: ListBackupPlansRequest): ListBackupPlansResponse {
        val op = SdkHttpOperation.build<ListBackupPlansRequest, ListBackupPlansResponse> {
            serializer = ListBackupPlansOperationSerializer()
            deserializer = ListBackupPlansOperationDeserializer()
            operationName = "ListBackupPlans"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array containing metadata of the resources associated with the target backup plan.
     */
    override suspend fun listBackupSelections(input: ListBackupSelectionsRequest): ListBackupSelectionsResponse {
        val op = SdkHttpOperation.build<ListBackupSelectionsRequest, ListBackupSelectionsResponse> {
            serializer = ListBackupSelectionsOperationSerializer()
            deserializer = ListBackupSelectionsOperationDeserializer()
            operationName = "ListBackupSelections"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of recovery point storage containers along with information about them.
     */
    override suspend fun listBackupVaults(input: ListBackupVaultsRequest): ListBackupVaultsResponse {
        val op = SdkHttpOperation.build<ListBackupVaultsRequest, ListBackupVaultsResponse> {
            serializer = ListBackupVaultsOperationSerializer()
            deserializer = ListBackupVaultsOperationDeserializer()
            operationName = "ListBackupVaults"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
     *
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
     */
    override suspend fun listCopyJobSummaries(input: ListCopyJobSummariesRequest): ListCopyJobSummariesResponse {
        val op = SdkHttpOperation.build<ListCopyJobSummariesRequest, ListCopyJobSummariesResponse> {
            serializer = ListCopyJobSummariesOperationSerializer()
            deserializer = ListCopyJobSummariesOperationDeserializer()
            operationName = "ListCopyJobSummaries"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about your copy jobs.
     */
    override suspend fun listCopyJobs(input: ListCopyJobsRequest): ListCopyJobsResponse {
        val op = SdkHttpOperation.build<ListCopyJobsRequest, ListCopyJobsResponse> {
            serializer = ListCopyJobsOperationSerializer()
            deserializer = ListCopyJobsOperationDeserializer()
            operationName = "ListCopyJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     */
    override suspend fun listFrameworks(input: ListFrameworksRequest): ListFrameworksResponse {
        val op = SdkHttpOperation.build<ListFrameworksRequest, ListFrameworksResponse> {
            serializer = ListFrameworksOperationSerializer()
            deserializer = ListFrameworksOperationDeserializer()
            operationName = "ListFrameworks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This action returns metadata about active and previous legal holds.
     */
    override suspend fun listLegalHolds(input: ListLegalHoldsRequest): ListLegalHoldsResponse {
        val op = SdkHttpOperation.build<ListLegalHoldsRequest, ListLegalHoldsResponse> {
            serializer = ListLegalHoldsOperationSerializer()
            deserializer = ListLegalHoldsOperationDeserializer()
            operationName = "ListLegalHolds"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.
     */
    override suspend fun listProtectedResources(input: ListProtectedResourcesRequest): ListProtectedResourcesResponse {
        val op = SdkHttpOperation.build<ListProtectedResourcesRequest, ListProtectedResourcesResponse> {
            serializer = ListProtectedResourcesOperationSerializer()
            deserializer = ListProtectedResourcesOperationDeserializer()
            operationName = "ListProtectedResources"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request lists the protected resources corresponding to each backup vault.
     */
    override suspend fun listProtectedResourcesByBackupVault(input: ListProtectedResourcesByBackupVaultRequest): ListProtectedResourcesByBackupVaultResponse {
        val op = SdkHttpOperation.build<ListProtectedResourcesByBackupVaultRequest, ListProtectedResourcesByBackupVaultResponse> {
            serializer = ListProtectedResourcesByBackupVaultOperationSerializer()
            deserializer = ListProtectedResourcesByBackupVaultOperationDeserializer()
            operationName = "ListProtectedResourcesByBackupVault"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about the recovery points stored in a backup vault.
     */
    override suspend fun listRecoveryPointsByBackupVault(input: ListRecoveryPointsByBackupVaultRequest): ListRecoveryPointsByBackupVaultResponse {
        val op = SdkHttpOperation.build<ListRecoveryPointsByBackupVaultRequest, ListRecoveryPointsByBackupVaultResponse> {
            serializer = ListRecoveryPointsByBackupVaultOperationSerializer()
            deserializer = ListRecoveryPointsByBackupVaultOperationDeserializer()
            operationName = "ListRecoveryPointsByBackupVault"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     */
    override suspend fun listRecoveryPointsByLegalHold(input: ListRecoveryPointsByLegalHoldRequest): ListRecoveryPointsByLegalHoldResponse {
        val op = SdkHttpOperation.build<ListRecoveryPointsByLegalHoldRequest, ListRecoveryPointsByLegalHoldResponse> {
            serializer = ListRecoveryPointsByLegalHoldOperationSerializer()
            deserializer = ListRecoveryPointsByLegalHoldOperationDeserializer()
            operationName = "ListRecoveryPointsByLegalHold"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).
     *
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     */
    override suspend fun listRecoveryPointsByResource(input: ListRecoveryPointsByResourceRequest): ListRecoveryPointsByResourceResponse {
        val op = SdkHttpOperation.build<ListRecoveryPointsByResourceRequest, ListRecoveryPointsByResourceResponse> {
            serializer = ListRecoveryPointsByResourceOperationSerializer()
            deserializer = ListRecoveryPointsByResourceOperationDeserializer()
            operationName = "ListRecoveryPointsByResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns details about your report jobs.
     */
    override suspend fun listReportJobs(input: ListReportJobsRequest): ListReportJobsResponse {
        val op = SdkHttpOperation.build<ListReportJobsRequest, ListReportJobsResponse> {
            serializer = ListReportJobsOperationSerializer()
            deserializer = ListReportJobsOperationDeserializer()
            operationName = "ListReportJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of your report plans. For detailed information about a single report plan, use `DescribeReportPlan`.
     */
    override suspend fun listReportPlans(input: ListReportPlansRequest): ListReportPlansResponse {
        val op = SdkHttpOperation.build<ListReportPlansRequest, ListReportPlansResponse> {
            serializer = ListReportPlansOperationSerializer()
            deserializer = ListReportPlansOperationDeserializer()
            operationName = "ListReportPlans"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     *
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
     */
    override suspend fun listRestoreJobSummaries(input: ListRestoreJobSummariesRequest): ListRestoreJobSummariesResponse {
        val op = SdkHttpOperation.build<ListRestoreJobSummariesRequest, ListRestoreJobSummariesResponse> {
            serializer = ListRestoreJobSummariesOperationSerializer()
            deserializer = ListRestoreJobSummariesOperationDeserializer()
            operationName = "ListRestoreJobSummaries"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.
     */
    override suspend fun listRestoreJobs(input: ListRestoreJobsRequest): ListRestoreJobsResponse {
        val op = SdkHttpOperation.build<ListRestoreJobsRequest, ListRestoreJobsResponse> {
            serializer = ListRestoreJobsOperationSerializer()
            deserializer = ListRestoreJobsOperationDeserializer()
            operationName = "ListRestoreJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This returns restore jobs that contain the specified protected resource.
     *
     * You must include `ResourceArn`. You can optionally include `NextToken`, `ByStatus`, `MaxResults`, `ByRecoveryPointCreationDateAfter` , and `ByRecoveryPointCreationDateBefore`.
     */
    override suspend fun listRestoreJobsByProtectedResource(input: ListRestoreJobsByProtectedResourceRequest): ListRestoreJobsByProtectedResourceResponse {
        val op = SdkHttpOperation.build<ListRestoreJobsByProtectedResourceRequest, ListRestoreJobsByProtectedResourceResponse> {
            serializer = ListRestoreJobsByProtectedResourceOperationSerializer()
            deserializer = ListRestoreJobsByProtectedResourceOperationDeserializer()
            operationName = "ListRestoreJobsByProtectedResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of restore testing plans.
     */
    override suspend fun listRestoreTestingPlans(input: ListRestoreTestingPlansRequest): ListRestoreTestingPlansResponse {
        val op = SdkHttpOperation.build<ListRestoreTestingPlansRequest, ListRestoreTestingPlansResponse> {
            serializer = ListRestoreTestingPlansOperationSerializer()
            deserializer = ListRestoreTestingPlansOperationDeserializer()
            operationName = "ListRestoreTestingPlans"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of restore testing selections. Can be filtered by `MaxResults` and `RestoreTestingPlanName`.
     */
    override suspend fun listRestoreTestingSelections(input: ListRestoreTestingSelectionsRequest): ListRestoreTestingSelectionsResponse {
        val op = SdkHttpOperation.build<ListRestoreTestingSelectionsRequest, ListRestoreTestingSelectionsResponse> {
            serializer = ListRestoreTestingSelectionsOperationSerializer()
            deserializer = ListRestoreTestingSelectionsOperationDeserializer()
            operationName = "ListRestoreTestingSelections"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     *
     * `ListTags` only works for resource types that support full Backup management of their backups. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            operationName = "ListTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.
     */
    override suspend fun putBackupVaultAccessPolicy(input: PutBackupVaultAccessPolicyRequest): PutBackupVaultAccessPolicyResponse {
        val op = SdkHttpOperation.build<PutBackupVaultAccessPolicyRequest, PutBackupVaultAccessPolicyResponse> {
            serializer = PutBackupVaultAccessPolicyOperationSerializer()
            deserializer = PutBackupVaultAccessPolicyOperationDeserializer()
            operationName = "PutBackupVaultAccessPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     *
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4, CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see the [Cohasset Associates Compliance Assessment.](samples/cohassetreport.zip)
     */
    override suspend fun putBackupVaultLockConfiguration(input: PutBackupVaultLockConfigurationRequest): PutBackupVaultLockConfigurationResponse {
        val op = SdkHttpOperation.build<PutBackupVaultLockConfigurationRequest, PutBackupVaultLockConfigurationResponse> {
            serializer = PutBackupVaultLockConfigurationOperationSerializer()
            deserializer = PutBackupVaultLockConfigurationOperationDeserializer()
            operationName = "PutBackupVaultLockConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Turns on notifications on a backup vault for the specified topic and events.
     */
    override suspend fun putBackupVaultNotifications(input: PutBackupVaultNotificationsRequest): PutBackupVaultNotificationsResponse {
        val op = SdkHttpOperation.build<PutBackupVaultNotificationsRequest, PutBackupVaultNotificationsResponse> {
            serializer = PutBackupVaultNotificationsOperationSerializer()
            deserializer = PutBackupVaultNotificationsOperationDeserializer()
            operationName = "PutBackupVaultNotifications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request allows you to send your independent self-run restore test validation results. `RestoreJobId` and `ValidationStatus` are required. Optionally, you can input a `ValidationStatusMessage`.
     */
    override suspend fun putRestoreValidationResult(input: PutRestoreValidationResultRequest): PutRestoreValidationResultResponse {
        val op = SdkHttpOperation.build<PutRestoreValidationResultRequest, PutRestoreValidationResultResponse> {
            serializer = PutRestoreValidationResultOperationSerializer()
            deserializer = PutRestoreValidationResultOperationDeserializer()
            operationName = "PutRestoreValidationResult"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts an on-demand backup job for the specified resource.
     */
    override suspend fun startBackupJob(input: StartBackupJobRequest): StartBackupJobResponse {
        val op = SdkHttpOperation.build<StartBackupJobRequest, StartBackupJobResponse> {
            serializer = StartBackupJobOperationSerializer()
            deserializer = StartBackupJobOperationDeserializer()
            operationName = "StartBackupJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a job to create a one-time copy of the specified resource.
     *
     * Does not support continuous backups.
     */
    override suspend fun startCopyJob(input: StartCopyJobRequest): StartCopyJobResponse {
        val op = SdkHttpOperation.build<StartCopyJobRequest, StartCopyJobResponse> {
            serializer = StartCopyJobOperationSerializer()
            deserializer = StartCopyJobOperationDeserializer()
            operationName = "StartCopyJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts an on-demand report job for the specified report plan.
     */
    override suspend fun startReportJob(input: StartReportJobRequest): StartReportJobResponse {
        val op = SdkHttpOperation.build<StartReportJobRequest, StartReportJobResponse> {
            serializer = StartReportJobOperationSerializer()
            deserializer = StartReportJobOperationDeserializer()
            operationName = "StartReportJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     */
    override suspend fun startRestoreJob(input: StartRestoreJobRequest): StartRestoreJobResponse {
        val op = SdkHttpOperation.build<StartRestoreJobRequest, StartRestoreJobResponse> {
            serializer = StartRestoreJobOperationSerializer()
            deserializer = StartRestoreJobOperationDeserializer()
            operationName = "StartRestoreJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attempts to cancel a job to create a one-time backup of a resource.
     *
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for Lustre, FSx for ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility), Amazon RDS, Amazon Aurora, and Amazon Neptune.
     */
    override suspend fun stopBackupJob(input: StopBackupJobRequest): StopBackupJobResponse {
        val op = SdkHttpOperation.build<StopBackupJobRequest, StopBackupJobResponse> {
            serializer = StopBackupJobOperationSerializer()
            deserializer = StopBackupJobOperationDeserializer()
            operationName = "StopBackupJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing backup plan identified by its `backupPlanId` with the input document in JSON format. The new version is uniquely identified by a `VersionId`.
     */
    override suspend fun updateBackupPlan(input: UpdateBackupPlanRequest): UpdateBackupPlanResponse {
        val op = SdkHttpOperation.build<UpdateBackupPlanRequest, UpdateBackupPlanResponse> {
            serializer = UpdateBackupPlanOperationSerializer()
            deserializer = UpdateBackupPlanOperationDeserializer()
            operationName = "UpdateBackupPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing framework identified by its `FrameworkName` with the input document in JSON format.
     */
    override suspend fun updateFramework(input: UpdateFrameworkRequest): UpdateFrameworkResponse {
        val op = SdkHttpOperation.build<UpdateFrameworkRequest, UpdateFrameworkResponse> {
            serializer = UpdateFrameworkOperationSerializer()
            deserializer = UpdateFrameworkOperationDeserializer()
            operationName = "UpdateFramework"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the `DescribeGlobalSettings` API to determine the current settings.
     */
    override suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest): UpdateGlobalSettingsResponse {
        val op = SdkHttpOperation.build<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse> {
            serializer = UpdateGlobalSettingsOperationSerializer()
            deserializer = UpdateGlobalSettingsOperationDeserializer()
            operationName = "UpdateGlobalSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the transition lifecycle of a recovery point.
     *
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     *
     * This operation does not support continuous backups.
     */
    override suspend fun updateRecoveryPointLifecycle(input: UpdateRecoveryPointLifecycleRequest): UpdateRecoveryPointLifecycleResponse {
        val op = SdkHttpOperation.build<UpdateRecoveryPointLifecycleRequest, UpdateRecoveryPointLifecycleResponse> {
            serializer = UpdateRecoveryPointLifecycleOperationSerializer()
            deserializer = UpdateRecoveryPointLifecycleOperationDeserializer()
            operationName = "UpdateRecoveryPointLifecycle"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the current service opt-in settings for the Region.
     *
     * Use the `DescribeRegionSettings` API to determine the resource types that are supported.
     */
    override suspend fun updateRegionSettings(input: UpdateRegionSettingsRequest): UpdateRegionSettingsResponse {
        val op = SdkHttpOperation.build<UpdateRegionSettingsRequest, UpdateRegionSettingsResponse> {
            serializer = UpdateRegionSettingsOperationSerializer()
            deserializer = UpdateRegionSettingsOperationDeserializer()
            operationName = "UpdateRegionSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing report plan identified by its `ReportPlanName` with the input document in JSON format.
     */
    override suspend fun updateReportPlan(input: UpdateReportPlanRequest): UpdateReportPlanResponse {
        val op = SdkHttpOperation.build<UpdateReportPlanRequest, UpdateReportPlanResponse> {
            serializer = UpdateReportPlanOperationSerializer()
            deserializer = UpdateReportPlanOperationDeserializer()
            operationName = "UpdateReportPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This request will send changes to your specified restore testing plan. `RestoreTestingPlanName` cannot be updated after it is created.
     *
     * `RecoveryPointSelection` can contain:
     * + `Algorithm`
     * + `ExcludeVaults`
     * + `IncludeVaults`
     * + `RecoveryPointTypes`
     * + `SelectionWindowDays`
     */
    override suspend fun updateRestoreTestingPlan(input: UpdateRestoreTestingPlanRequest): UpdateRestoreTestingPlanResponse {
        val op = SdkHttpOperation.build<UpdateRestoreTestingPlanRequest, UpdateRestoreTestingPlanResponse> {
            serializer = UpdateRestoreTestingPlanOperationSerializer()
            deserializer = UpdateRestoreTestingPlanOperationDeserializer()
            operationName = "UpdateRestoreTestingPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Most elements except the `RestoreTestingSelectionName` can be updated with this request.
     *
     * `RestoreTestingSelection` can use either protected resource ARNs or conditions, but not both. That is, if your selection has `ProtectedResourceArns`, requesting an update with the parameter `ProtectedResourceConditions` will be unsuccessful.
     */
    override suspend fun updateRestoreTestingSelection(input: UpdateRestoreTestingSelectionRequest): UpdateRestoreTestingSelectionResponse {
        val op = SdkHttpOperation.build<UpdateRestoreTestingSelectionRequest, UpdateRestoreTestingSelectionResponse> {
            serializer = UpdateRestoreTestingSelectionOperationSerializer()
            deserializer = UpdateRestoreTestingSelectionOperationDeserializer()
            operationName = "UpdateRestoreTestingSelection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "backup")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
