// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.UpdateRestoreTestingPlanResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateRestoreTestingPlanOperationDeserializer: HttpDeserialize<UpdateRestoreTestingPlanResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateRestoreTestingPlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateRestoreTestingPlanError(context, call)
        }
        val builder = UpdateRestoreTestingPlanResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRestoreTestingPlanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateRestoreTestingPlanError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRestoreTestingPlanOperationBody(builder: UpdateRestoreTestingPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val RESTORETESTINGPLANARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RestoreTestingPlanArn"))
    val RESTORETESTINGPLANNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RestoreTestingPlanName"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(RESTORETESTINGPLANARN_DESCRIPTOR)
        field(RESTORETESTINGPLANNAME_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                RESTORETESTINGPLANARN_DESCRIPTOR.index -> builder.restoreTestingPlanArn = deserializeString()
                RESTORETESTINGPLANNAME_DESCRIPTOR.index -> builder.restoreTestingPlanName = deserializeString()
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
