// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.DescribeProtectedResourceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeProtectedResourceOperationDeserializer: HttpDeserialize<DescribeProtectedResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeProtectedResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeProtectedResourceError(context, call)
        }
        val builder = DescribeProtectedResourceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProtectedResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeProtectedResourceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProtectedResourceOperationBody(builder: DescribeProtectedResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTBACKUPTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastBackupTime"))
    val LASTBACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastBackupVaultArn"))
    val LASTRECOVERYPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastRecoveryPointArn"))
    val LATESTRESTOREEXECUTIONTIMEMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("LatestRestoreExecutionTimeMinutes"))
    val LATESTRESTOREJOBCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestRestoreJobCreationDate"))
    val LATESTRESTORERECOVERYPOINTCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestRestoreRecoveryPointCreationDate"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val RESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceName"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTBACKUPTIME_DESCRIPTOR)
        field(LASTBACKUPVAULTARN_DESCRIPTOR)
        field(LASTRECOVERYPOINTARN_DESCRIPTOR)
        field(LATESTRESTOREEXECUTIONTIMEMINUTES_DESCRIPTOR)
        field(LATESTRESTOREJOBCREATIONDATE_DESCRIPTOR)
        field(LATESTRESTORERECOVERYPOINTCREATIONDATE_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(RESOURCENAME_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTBACKUPTIME_DESCRIPTOR.index -> builder.lastBackupTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTBACKUPVAULTARN_DESCRIPTOR.index -> builder.lastBackupVaultArn = deserializeString()
                LASTRECOVERYPOINTARN_DESCRIPTOR.index -> builder.lastRecoveryPointArn = deserializeString()
                LATESTRESTOREEXECUTIONTIMEMINUTES_DESCRIPTOR.index -> builder.latestRestoreExecutionTimeMinutes = deserializeLong()
                LATESTRESTOREJOBCREATIONDATE_DESCRIPTOR.index -> builder.latestRestoreJobCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                LATESTRESTORERECOVERYPOINTCREATIONDATE_DESCRIPTOR.index -> builder.latestRestoreRecoveryPointCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                RESOURCENAME_DESCRIPTOR.index -> builder.resourceName = deserializeString()
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
