// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.CreateLegalHoldResponse
import aws.sdk.kotlin.services.backup.model.LegalHoldStatus
import aws.sdk.kotlin.services.backup.model.RecoveryPointSelection
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateLegalHoldOperationDeserializer: HttpDeserialize<CreateLegalHoldResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateLegalHoldResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateLegalHoldError(context, call)
        }
        val builder = CreateLegalHoldResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateLegalHoldOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateLegalHoldError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateLegalHoldOperationBody(builder: CreateLegalHoldResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LEGALHOLDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LegalHoldArn"))
    val LEGALHOLDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LegalHoldId"))
    val RECOVERYPOINTSELECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RecoveryPointSelection"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Title"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LEGALHOLDARN_DESCRIPTOR)
        field(LEGALHOLDID_DESCRIPTOR)
        field(RECOVERYPOINTSELECTION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LEGALHOLDARN_DESCRIPTOR.index -> builder.legalHoldArn = deserializeString()
                LEGALHOLDID_DESCRIPTOR.index -> builder.legalHoldId = deserializeString()
                RECOVERYPOINTSELECTION_DESCRIPTOR.index -> builder.recoveryPointSelection = deserializeRecoveryPointSelectionDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LegalHoldStatus.fromValue(it) }
                TITLE_DESCRIPTOR.index -> builder.title = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
