// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class StartRestoreJobRequest private constructor(builder: Builder) {
    /**
     * This is an optional parameter. If this equals `True`, tags included in the backup will be copied to the restored resource.
     *
     * This can only be applied to backups created through Backup.
     */
    public val copySourceTagsToRestoredResource: kotlin.Boolean? = builder.copySourceTagsToRestoredResource
    /**
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartRestoreJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * A set of metadata key-value pairs. Contains information, such as a resource name, required to restore a recovery point.
     *
     *  You can get configuration metadata about a resource at the time it was backed up by calling `GetRecoveryPointRestoreMetadata`. However, values in addition to those provided by `GetRecoveryPointRestoreMetadata` might be required to restore a resource. For example, you might need to provide a new resource name if the original already exists.
     *
     * You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:
     * + `file-system-id`: The ID of the Amazon EFS file system that is backed up by Backup. Returned in `GetRecoveryPointRestoreMetadata`.
     * + `Encrypted`: A Boolean value that, if true, specifies that the file system is encrypted. If `KmsKeyId` is specified, `Encrypted` must be set to `true`.
     * + `KmsKeyId`: Specifies the Amazon Web Services KMS key that is used to encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.
     * + `PerformanceMode`: Specifies the throughput mode of the file system.
     * + `CreationToken`: A user-supplied value that ensures the uniqueness (idempotency) of the request.
     * + `newFileSystem`: A Boolean value that, if true, specifies that the recovery point is restored to a new Amazon EFS file system.
     * + `ItemsToRestore`: An array of one to five strings where each string is a file path. Use `ItemsToRestore` to restore specific files or directories rather than the entire file system. This parameter is optional. For example, `"itemsToRestore":"[\"/my.test\"]"`.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * Starts a job to restore a recovery point for one of the following resources:
     * + `Aurora` for Amazon Aurora
     * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
     * + `CloudFormation` for CloudFormation
     * + `DynamoDB` for Amazon DynamoDB
     * + `EBS` for Amazon Elastic Block Store
     * + `EC2` for Amazon Elastic Compute Cloud
     * + `EFS` for Amazon Elastic File System
     * + `FSx` for Amazon FSx
     * + `Neptune` for Amazon Neptune
     * + `RDS` for Amazon Relational Database Service
     * + `Redshift` for Amazon Redshift
     * + `Storage Gateway` for Storage Gateway
     * + `S3` for Amazon S3
     * + `Timestream` for Amazon Timestream
     * + `VirtualMachine` for virtual machines
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartRestoreJobRequest(")
        append("copySourceTagsToRestoredResource=$copySourceTagsToRestoredResource,")
        append("iamRoleArn=$iamRoleArn,")
        append("idempotencyToken=$idempotencyToken,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copySourceTagsToRestoredResource?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartRestoreJobRequest

        if (copySourceTagsToRestoredResource != other.copySourceTagsToRestoredResource) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (metadata != other.metadata) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is an optional parameter. If this equals `True`, tags included in the backup will be copied to the restored resource.
         *
         * This can only be applied to backups created through Backup.
         */
        public var copySourceTagsToRestoredResource: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartRestoreJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * A set of metadata key-value pairs. Contains information, such as a resource name, required to restore a recovery point.
         *
         *  You can get configuration metadata about a resource at the time it was backed up by calling `GetRecoveryPointRestoreMetadata`. However, values in addition to those provided by `GetRecoveryPointRestoreMetadata` might be required to restore a resource. For example, you might need to provide a new resource name if the original already exists.
         *
         * You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:
         * + `file-system-id`: The ID of the Amazon EFS file system that is backed up by Backup. Returned in `GetRecoveryPointRestoreMetadata`.
         * + `Encrypted`: A Boolean value that, if true, specifies that the file system is encrypted. If `KmsKeyId` is specified, `Encrypted` must be set to `true`.
         * + `KmsKeyId`: Specifies the Amazon Web Services KMS key that is used to encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.
         * + `PerformanceMode`: Specifies the throughput mode of the file system.
         * + `CreationToken`: A user-supplied value that ensures the uniqueness (idempotency) of the request.
         * + `newFileSystem`: A Boolean value that, if true, specifies that the recovery point is restored to a new Amazon EFS file system.
         * + `ItemsToRestore`: An array of one to five strings where each string is a file path. Use `ItemsToRestore` to restore specific files or directories rather than the entire file system. This parameter is optional. For example, `"itemsToRestore":"[\"/my.test\"]"`.
         */
        public var metadata: Map<String, String>? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * Starts a job to restore a recovery point for one of the following resources:
         * + `Aurora` for Amazon Aurora
         * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
         * + `CloudFormation` for CloudFormation
         * + `DynamoDB` for Amazon DynamoDB
         * + `EBS` for Amazon Elastic Block Store
         * + `EC2` for Amazon Elastic Compute Cloud
         * + `EFS` for Amazon Elastic File System
         * + `FSx` for Amazon FSx
         * + `Neptune` for Amazon Neptune
         * + `RDS` for Amazon Relational Database Service
         * + `Redshift` for Amazon Redshift
         * + `Storage Gateway` for Storage Gateway
         * + `S3` for Amazon S3
         * + `Timestream` for Amazon Timestream
         * + `VirtualMachine` for virtual machines
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest) : this() {
            this.copySourceTagsToRestoredResource = x.copySourceTagsToRestoredResource
            this.iamRoleArn = x.iamRoleArn
            this.idempotencyToken = x.idempotencyToken
            this.metadata = x.metadata
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest = StartRestoreJobRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
