// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class ListRestoreJobSummariesRequest private constructor(builder: Builder) {
    /**
     * Returns the job count for the specified account.
     *
     * If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs within requestor's account will be returned.
     *
     * Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account in the organization.
     *
     * `AGGREGATE_ALL` aggregates job counts from all accounts within the authenticated organization, then returns the sum.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * This is the period that sets the boundaries for returned results.
     *
     * Acceptable values include
     * + `ONE_DAY` for daily job count for the prior 14 days.
     * + `SEVEN_DAYS` for the aggregated job count for the prior 7 days.
     * + `FOURTEEN_DAYS` for aggregated job count for prior 14 days.
     */
    public val aggregationPeriod: aws.sdk.kotlin.services.backup.model.AggregationPeriod? = builder.aggregationPeriod
    /**
     * This parameter sets the maximum number of items to be returned.
     *
     * The value is an integer. Range of accepted values is from 1 to 500.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The next item following a partial list of returned resources. For example, if a request is made to return `MaxResults` number of resources, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Returns the job count for the specified resource type. Use request `GetSupportedResourceTypes` to obtain strings for supported resource types.
     *
     * The the value ANY returns count of all resource types.
     *
     * `AGGREGATE_ALL` aggregates job counts for all resource types and returns the sum.
     *
     * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * This parameter returns the job count for jobs with the specified state.
     *
     * The the value ANY returns count of all states.
     *
     * `AGGREGATE_ALL` aggregates job counts for all states and returns the sum.
     */
    public val state: aws.sdk.kotlin.services.backup.model.RestoreJobState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListRestoreJobSummariesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRestoreJobSummariesRequest(")
        append("accountId=$accountId,")
        append("aggregationPeriod=$aggregationPeriod,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceType=$resourceType,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (aggregationPeriod?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRestoreJobSummariesRequest

        if (accountId != other.accountId) return false
        if (aggregationPeriod != other.aggregationPeriod) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceType != other.resourceType) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListRestoreJobSummariesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Returns the job count for the specified account.
         *
         * If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs within requestor's account will be returned.
         *
         * Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account in the organization.
         *
         * `AGGREGATE_ALL` aggregates job counts from all accounts within the authenticated organization, then returns the sum.
         */
        public var accountId: kotlin.String? = null
        /**
         * This is the period that sets the boundaries for returned results.
         *
         * Acceptable values include
         * + `ONE_DAY` for daily job count for the prior 14 days.
         * + `SEVEN_DAYS` for the aggregated job count for the prior 7 days.
         * + `FOURTEEN_DAYS` for aggregated job count for prior 14 days.
         */
        public var aggregationPeriod: aws.sdk.kotlin.services.backup.model.AggregationPeriod? = null
        /**
         * This parameter sets the maximum number of items to be returned.
         *
         * The value is an integer. Range of accepted values is from 1 to 500.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The next item following a partial list of returned resources. For example, if a request is made to return `MaxResults` number of resources, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Returns the job count for the specified resource type. Use request `GetSupportedResourceTypes` to obtain strings for supported resource types.
         *
         * The the value ANY returns count of all resource types.
         *
         * `AGGREGATE_ALL` aggregates job counts for all resource types and returns the sum.
         *
         * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         */
        public var resourceType: kotlin.String? = null
        /**
         * This parameter returns the job count for jobs with the specified state.
         *
         * The the value ANY returns count of all states.
         *
         * `AGGREGATE_ALL` aggregates job counts for all states and returns the sum.
         */
        public var state: aws.sdk.kotlin.services.backup.model.RestoreJobState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListRestoreJobSummariesRequest) : this() {
            this.accountId = x.accountId
            this.aggregationPeriod = x.aggregationPeriod
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceType = x.resourceType
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListRestoreJobSummariesRequest = ListRestoreJobSummariesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
