// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListRecoveryPointsByBackupVaultRequest private constructor(builder: Builder) {
    /**
     * This parameter will sort the list of recovery points by account ID.
     */
    public val backupVaultAccountId: kotlin.String? = builder.backupVaultAccountId
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     *
     * Backup vault name might not be available when a supported service creates the backup.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * Returns only recovery points that match the specified backup plan ID.
     */
    public val byBackupPlanId: kotlin.String? = builder.byBackupPlanId
    /**
     * Returns only recovery points that were created after the specified timestamp.
     */
    public val byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedAfter
    /**
     * Returns only recovery points that were created before the specified timestamp.
     */
    public val byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedBefore
    /**
     * This returns only recovery points that match the specified parent (composite) recovery point Amazon Resource Name (ARN).
     */
    public val byParentRecoveryPointArn: kotlin.String? = builder.byParentRecoveryPointArn
    /**
     * Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
     */
    public val byResourceArn: kotlin.String? = builder.byResourceArn
    /**
     * Returns only recovery points that match the specified resource type(s):
     * + `Aurora` for Amazon Aurora
     * + `CloudFormation` for CloudFormation
     * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
     * + `DynamoDB` for Amazon DynamoDB
     * + `EBS` for Amazon Elastic Block Store
     * + `EC2` for Amazon Elastic Compute Cloud
     * + `EFS` for Amazon Elastic File System
     * + `FSx` for Amazon FSx
     * + `Neptune` for Amazon Neptune
     * + `Redshift` for Amazon Redshift
     * + `RDS` for Amazon Relational Database Service
     * + `SAP HANA on Amazon EC2` for SAP HANA databases
     * + `Storage Gateway` for Storage Gateway
     * + `S3` for Amazon S3
     * + `Timestream` for Amazon Timestream
     * + `VirtualMachine` for virtual machines
     */
    public val byResourceType: kotlin.String? = builder.byResourceType
    /**
     * The maximum number of items to be returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The next item following a partial list of returned items. For example, if a request is made to return `MaxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRecoveryPointsByBackupVaultRequest(")
        append("backupVaultAccountId=$backupVaultAccountId,")
        append("backupVaultName=$backupVaultName,")
        append("byBackupPlanId=$byBackupPlanId,")
        append("byCreatedAfter=$byCreatedAfter,")
        append("byCreatedBefore=$byCreatedBefore,")
        append("byParentRecoveryPointArn=$byParentRecoveryPointArn,")
        append("byResourceArn=$byResourceArn,")
        append("byResourceType=$byResourceType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultAccountId?.hashCode() ?: 0
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (byBackupPlanId?.hashCode() ?: 0)
        result = 31 * result + (byCreatedAfter?.hashCode() ?: 0)
        result = 31 * result + (byCreatedBefore?.hashCode() ?: 0)
        result = 31 * result + (byParentRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (byResourceArn?.hashCode() ?: 0)
        result = 31 * result + (byResourceType?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRecoveryPointsByBackupVaultRequest

        if (backupVaultAccountId != other.backupVaultAccountId) return false
        if (backupVaultName != other.backupVaultName) return false
        if (byBackupPlanId != other.byBackupPlanId) return false
        if (byCreatedAfter != other.byCreatedAfter) return false
        if (byCreatedBefore != other.byCreatedBefore) return false
        if (byParentRecoveryPointArn != other.byParentRecoveryPointArn) return false
        if (byResourceArn != other.byResourceArn) return false
        if (byResourceType != other.byResourceType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This parameter will sort the list of recovery points by account ID.
         */
        public var backupVaultAccountId: kotlin.String? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         *
         * Backup vault name might not be available when a supported service creates the backup.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * Returns only recovery points that match the specified backup plan ID.
         */
        public var byBackupPlanId: kotlin.String? = null
        /**
         * Returns only recovery points that were created after the specified timestamp.
         */
        public var byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only recovery points that were created before the specified timestamp.
         */
        public var byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This returns only recovery points that match the specified parent (composite) recovery point Amazon Resource Name (ARN).
         */
        public var byParentRecoveryPointArn: kotlin.String? = null
        /**
         * Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
         */
        public var byResourceArn: kotlin.String? = null
        /**
         * Returns only recovery points that match the specified resource type(s):
         * + `Aurora` for Amazon Aurora
         * + `CloudFormation` for CloudFormation
         * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
         * + `DynamoDB` for Amazon DynamoDB
         * + `EBS` for Amazon Elastic Block Store
         * + `EC2` for Amazon Elastic Compute Cloud
         * + `EFS` for Amazon Elastic File System
         * + `FSx` for Amazon FSx
         * + `Neptune` for Amazon Neptune
         * + `Redshift` for Amazon Redshift
         * + `RDS` for Amazon Relational Database Service
         * + `SAP HANA on Amazon EC2` for SAP HANA databases
         * + `Storage Gateway` for Storage Gateway
         * + `S3` for Amazon S3
         * + `Timestream` for Amazon Timestream
         * + `VirtualMachine` for virtual machines
         */
        public var byResourceType: kotlin.String? = null
        /**
         * The maximum number of items to be returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The next item following a partial list of returned items. For example, if a request is made to return `MaxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest) : this() {
            this.backupVaultAccountId = x.backupVaultAccountId
            this.backupVaultName = x.backupVaultName
            this.byBackupPlanId = x.byBackupPlanId
            this.byCreatedAfter = x.byCreatedAfter
            this.byCreatedBefore = x.byCreatedBefore
            this.byParentRecoveryPointArn = x.byParentRecoveryPointArn
            this.byResourceArn = x.byResourceArn
            this.byResourceType = x.byResourceType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest = ListRecoveryPointsByBackupVaultRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
